/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.MessageQueue;

public class RequestHandlerThread
extends HandlerThread {
    public static final int MSG_POKE_IDLE_HANDLER = -1;
    private final ConditionVariable mStarted = new ConditionVariable(false);
    private final ConditionVariable mIdle = new ConditionVariable(true);
    private Handler.Callback mCallback;
    private volatile Handler mHandler;
    private final MessageQueue.IdleHandler mIdleHandler = new MessageQueue.IdleHandler(){

        @Override
        public boolean queueIdle() {
            RequestHandlerThread.this.mIdle.open();
            return false;
        }
    };

    public RequestHandlerThread(String name, Handler.Callback callback) {
        super(name, 10);
        this.mCallback = callback;
    }

    @Override
    protected void onLooperPrepared() {
        this.mHandler = new Handler(this.getLooper(), this.mCallback);
        this.mStarted.open();
    }

    public void waitUntilStarted() {
        this.mStarted.block();
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public Handler waitAndGetHandler() {
        this.waitUntilStarted();
        return this.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyMessages(int[] what) {
        MessageQueue messageQueue = this.mHandler.getLooper().getQueue();
        synchronized (messageQueue) {
            for (int i : what) {
                if (!this.mHandler.hasMessages(i)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessages(int[] what) {
        MessageQueue messageQueue = this.mHandler.getLooper().getQueue();
        synchronized (messageQueue) {
            for (int i : what) {
                this.mHandler.removeMessages(i);
            }
        }
    }

    public void waitUntilIdle() {
        Handler handler = this.waitAndGetHandler();
        MessageQueue queue = handler.getLooper().getQueue();
        if (queue.isIdle()) {
            return;
        }
        this.mIdle.close();
        queue.addIdleHandler(this.mIdleHandler);
        handler.sendEmptyMessage(-1);
        if (queue.isIdle()) {
            return;
        }
        this.mIdle.block();
    }
}

