/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.RSDriverException;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import android.util.SparseArray;
import java.io.UnsupportedEncodingException;

public class Script
extends BaseObj {
    private final SparseArray<KernelID> mKIDs = new SparseArray();
    private final SparseArray<InvokeID> mIIDs = new SparseArray();
    private final SparseArray<FieldID> mFIDs = new SparseArray();
    long[] mInIdsBuffer = new long[1];

    protected KernelID createKernelID(int slot, int sig, Element ein, Element eout) {
        KernelID k = this.mKIDs.get(slot);
        if (k != null) {
            return k;
        }
        long id2 = this.mRS.nScriptKernelIDCreate(this.getID(this.mRS), slot, sig);
        if (id2 == 0L) {
            throw new RSDriverException("Failed to create KernelID");
        }
        k = new KernelID(id2, this.mRS, this, slot, sig);
        this.mKIDs.put(slot, k);
        return k;
    }

    protected InvokeID createInvokeID(int slot) {
        InvokeID i = this.mIIDs.get(slot);
        if (i != null) {
            return i;
        }
        long id2 = this.mRS.nScriptInvokeIDCreate(this.getID(this.mRS), slot);
        if (id2 == 0L) {
            throw new RSDriverException("Failed to create KernelID");
        }
        i = new InvokeID(id2, this.mRS, this, slot);
        this.mIIDs.put(slot, i);
        return i;
    }

    protected FieldID createFieldID(int slot, Element e) {
        FieldID f = this.mFIDs.get(slot);
        if (f != null) {
            return f;
        }
        long id2 = this.mRS.nScriptFieldIDCreate(this.getID(this.mRS), slot);
        if (id2 == 0L) {
            throw new RSDriverException("Failed to create FieldID");
        }
        f = new FieldID(id2, this.mRS, this, slot);
        this.mFIDs.put(slot, f);
        return f;
    }

    protected void invoke(int slot) {
        this.mRS.nScriptInvoke(this.getID(this.mRS), slot);
    }

    protected void invoke(int slot, FieldPacker v) {
        if (v != null) {
            this.mRS.nScriptInvokeV(this.getID(this.mRS), slot, v.getData());
        } else {
            this.mRS.nScriptInvoke(this.getID(this.mRS), slot);
        }
    }

    protected void forEach(int slot, Allocation ain, Allocation aout, FieldPacker v) {
        this.forEach(slot, ain, aout, v, null);
    }

    protected void forEach(int slot, Allocation ain, Allocation aout, FieldPacker v, LaunchOptions sc) {
        this.mRS.validate();
        this.mRS.validateObject(ain);
        this.mRS.validateObject(aout);
        if (ain == null && aout == null && sc == null) {
            throw new RSIllegalArgumentException("At least one of input allocation, output allocation, or LaunchOptions is required to be non-null.");
        }
        long[] in_ids = null;
        if (ain != null) {
            in_ids = this.mInIdsBuffer;
            in_ids[0] = ain.getID(this.mRS);
        }
        long out_id = 0L;
        if (aout != null) {
            out_id = aout.getID(this.mRS);
        }
        byte[] params = null;
        if (v != null) {
            params = v.getData();
        }
        int[] limits = null;
        if (sc != null) {
            limits = new int[]{sc.xstart, sc.xend, sc.ystart, sc.yend, sc.zstart, sc.zend};
        }
        this.mRS.nScriptForEach(this.getID(this.mRS), slot, in_ids, out_id, params, limits);
    }

    protected void forEach(int slot, Allocation[] ains, Allocation aout, FieldPacker v) {
        this.forEach(slot, ains, aout, v, null);
    }

    protected void forEach(int slot, Allocation[] ains, Allocation aout, FieldPacker v, LaunchOptions sc) {
        long[] in_ids;
        this.mRS.validate();
        if (ains != null) {
            for (Allocation ain : ains) {
                this.mRS.validateObject(ain);
            }
        }
        this.mRS.validateObject(aout);
        if (ains == null && aout == null) {
            throw new RSIllegalArgumentException("At least one of ain or aout is required to be non-null.");
        }
        if (ains != null) {
            in_ids = new long[ains.length];
            for (int index = 0; index < ains.length; ++index) {
                in_ids[index] = ains[index].getID(this.mRS);
            }
        } else {
            in_ids = null;
        }
        long out_id = 0L;
        if (aout != null) {
            out_id = aout.getID(this.mRS);
        }
        byte[] params = null;
        if (v != null) {
            params = v.getData();
        }
        int[] limits = null;
        if (sc != null) {
            limits = new int[]{sc.xstart, sc.xend, sc.ystart, sc.yend, sc.zstart, sc.zend};
        }
        this.mRS.nScriptForEach(this.getID(this.mRS), slot, in_ids, out_id, params, limits);
    }

    protected void reduce(int slot, Allocation[] ains, Allocation aout, LaunchOptions sc) {
        this.mRS.validate();
        if (ains == null || ains.length < 1) {
            throw new RSIllegalArgumentException("At least one input is required.");
        }
        if (aout == null) {
            throw new RSIllegalArgumentException("aout is required to be non-null.");
        }
        for (Allocation ain : ains) {
            this.mRS.validateObject(ain);
        }
        long[] in_ids = new long[ains.length];
        for (int index = 0; index < ains.length; ++index) {
            in_ids[index] = ains[index].getID(this.mRS);
        }
        long out_id = aout.getID(this.mRS);
        int[] limits = null;
        if (sc != null) {
            limits = new int[]{sc.xstart, sc.xend, sc.ystart, sc.yend, sc.zstart, sc.zend};
        }
        this.mRS.nScriptReduce(this.getID(this.mRS), slot, in_ids, out_id, limits);
    }

    Script(long id2, RenderScript rs) {
        super(id2, rs);
        this.guard.open("destroy");
    }

    public void bindAllocation(Allocation va, int slot) {
        this.mRS.validate();
        this.mRS.validateObject(va);
        if (va != null) {
            Type t;
            Context context = this.mRS.getApplicationContext();
            if (context.getApplicationInfo().targetSdkVersion >= 20 && ((t = va.mType).hasMipmaps() || t.hasFaces() || t.getY() != 0 || t.getZ() != 0)) {
                throw new RSIllegalArgumentException("API 20+ only allows simple 1D allocations to be used with bind.");
            }
            this.mRS.nScriptBindAllocation(this.getID(this.mRS), va.getID(this.mRS), slot);
        } else {
            this.mRS.nScriptBindAllocation(this.getID(this.mRS), 0L, slot);
        }
    }

    public void setVar(int index, float v) {
        this.mRS.nScriptSetVarF(this.getID(this.mRS), index, v);
    }

    public float getVarF(int index) {
        return this.mRS.nScriptGetVarF(this.getID(this.mRS), index);
    }

    public void setVar(int index, double v) {
        this.mRS.nScriptSetVarD(this.getID(this.mRS), index, v);
    }

    public double getVarD(int index) {
        return this.mRS.nScriptGetVarD(this.getID(this.mRS), index);
    }

    public void setVar(int index, int v) {
        this.mRS.nScriptSetVarI(this.getID(this.mRS), index, v);
    }

    public int getVarI(int index) {
        return this.mRS.nScriptGetVarI(this.getID(this.mRS), index);
    }

    public void setVar(int index, long v) {
        this.mRS.nScriptSetVarJ(this.getID(this.mRS), index, v);
    }

    public long getVarJ(int index) {
        return this.mRS.nScriptGetVarJ(this.getID(this.mRS), index);
    }

    public void setVar(int index, boolean v) {
        this.mRS.nScriptSetVarI(this.getID(this.mRS), index, v ? 1 : 0);
    }

    public boolean getVarB(int index) {
        return this.mRS.nScriptGetVarI(this.getID(this.mRS), index) > 0;
    }

    public void setVar(int index, BaseObj o) {
        this.mRS.validate();
        this.mRS.validateObject(o);
        this.mRS.nScriptSetVarObj(this.getID(this.mRS), index, o == null ? 0L : o.getID(this.mRS));
    }

    public void setVar(int index, FieldPacker v) {
        this.mRS.nScriptSetVarV(this.getID(this.mRS), index, v.getData());
    }

    public void setVar(int index, FieldPacker v, Element e, int[] dims) {
        this.mRS.nScriptSetVarVE(this.getID(this.mRS), index, v.getData(), e.getID(this.mRS), dims);
    }

    public void getVarV(int index, FieldPacker v) {
        this.mRS.nScriptGetVarV(this.getID(this.mRS), index, v.getData());
    }

    public void setTimeZone(String timeZone) {
        this.mRS.validate();
        try {
            this.mRS.nScriptSetTimeZone(this.getID(this.mRS), timeZone.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class LaunchOptions {
        private int xstart = 0;
        private int ystart = 0;
        private int xend = 0;
        private int yend = 0;
        private int zstart = 0;
        private int zend = 0;
        private int strategy;

        public LaunchOptions setX(int xstartArg, int xendArg) {
            if (xstartArg < 0 || xendArg <= xstartArg) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.xstart = xstartArg;
            this.xend = xendArg;
            return this;
        }

        public LaunchOptions setY(int ystartArg, int yendArg) {
            if (ystartArg < 0 || yendArg <= ystartArg) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.ystart = ystartArg;
            this.yend = yendArg;
            return this;
        }

        public LaunchOptions setZ(int zstartArg, int zendArg) {
            if (zstartArg < 0 || zendArg <= zstartArg) {
                throw new RSIllegalArgumentException("Invalid dimensions");
            }
            this.zstart = zstartArg;
            this.zend = zendArg;
            return this;
        }

        public int getXStart() {
            return this.xstart;
        }

        public int getXEnd() {
            return this.xend;
        }

        public int getYStart() {
            return this.ystart;
        }

        public int getYEnd() {
            return this.yend;
        }

        public int getZStart() {
            return this.zstart;
        }

        public int getZEnd() {
            return this.zend;
        }
    }

    public static class FieldBase {
        protected Element mElement;
        protected Allocation mAllocation;

        protected void init(RenderScript rs, int dimx) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1);
        }

        protected void init(RenderScript rs, int dimx, int usages) {
            this.mAllocation = Allocation.createSized(rs, this.mElement, dimx, 1 | usages);
        }

        protected FieldBase() {
        }

        public Element getElement() {
            return this.mElement;
        }

        public Type getType() {
            return this.mAllocation.getType();
        }

        public Allocation getAllocation() {
            return this.mAllocation;
        }

        public void updateAllocation() {
        }
    }

    public static class Builder {
        RenderScript mRS;

        Builder(RenderScript rs) {
            this.mRS = rs;
        }
    }

    public static class FieldID
    extends BaseObj {
        Script mScript;
        int mSlot;

        FieldID(long id2, RenderScript rs, Script s, int slot) {
            super(id2, rs);
            this.mScript = s;
            this.mSlot = slot;
            this.guard.open("destroy");
        }
    }

    public static class InvokeID
    extends BaseObj {
        Script mScript;
        int mSlot;

        InvokeID(long id2, RenderScript rs, Script s, int slot) {
            super(id2, rs);
            this.mScript = s;
            this.mSlot = slot;
        }
    }

    public static class KernelID
    extends BaseObj {
        Script mScript;
        int mSlot;
        int mSig;

        KernelID(long id2, RenderScript rs, Script s, int slot, int sig) {
            super(id2, rs);
            this.mScript = s;
            this.mSlot = slot;
            this.mSig = sig;
            this.guard.open("destroy");
        }
    }
}

