/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class BluetoothPowerCalculator
extends PowerCalculator {
    private static final boolean DEBUG = false;
    private static final String TAG = "BluetoothPowerCalculator";
    private final double mIdleMa;
    private final double mRxMa;
    private final double mTxMa;
    private double mAppTotalPowerMah = 0.0;
    private long mAppTotalTimeMs = 0L;

    public BluetoothPowerCalculator(PowerProfile profile) {
        this.mIdleMa = profile.getAveragePower("bluetooth.controller.idle");
        this.mRxMa = profile.getAveragePower("bluetooth.controller.rx");
        this.mTxMa = profile.getAveragePower("bluetooth.controller.tx");
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.ControllerActivityCounter counter = u.getBluetoothControllerActivity();
        if (counter == null) {
            return;
        }
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(statsType);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(statsType);
        long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(statsType);
        long totalTimeMs = idleTimeMs + txTimeMs + rxTimeMs;
        double powerMah = (double)counter.getPowerCounter().getCountLocked(statsType) / 3600000.0;
        if (powerMah == 0.0) {
            powerMah = ((double)idleTimeMs * this.mIdleMa + (double)rxTimeMs * this.mRxMa + (double)txTimeMs * this.mTxMa) / 3600000.0;
        }
        app.bluetoothPowerMah = powerMah;
        app.bluetoothRunningTimeMs = totalTimeMs;
        app.btRxBytes = u.getNetworkActivityBytes(4, statsType);
        app.btTxBytes = u.getNetworkActivityBytes(5, statsType);
        this.mAppTotalPowerMah += powerMah;
        this.mAppTotalTimeMs += totalTimeMs;
    }

    @Override
    public void calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        BatteryStats.ControllerActivityCounter counter = stats.getBluetoothControllerActivity();
        long idleTimeMs = counter.getIdleTimeCounter().getCountLocked(statsType);
        long txTimeMs = counter.getTxTimeCounters()[0].getCountLocked(statsType);
        long rxTimeMs = counter.getRxTimeCounter().getCountLocked(statsType);
        long totalTimeMs = idleTimeMs + txTimeMs + rxTimeMs;
        double powerMah = (double)counter.getPowerCounter().getCountLocked(statsType) / 3600000.0;
        if (powerMah == 0.0) {
            powerMah = ((double)idleTimeMs * this.mIdleMa + (double)rxTimeMs * this.mRxMa + (double)txTimeMs * this.mTxMa) / 3600000.0;
        }
        app.bluetoothPowerMah = powerMah = Math.max(0.0, powerMah - this.mAppTotalPowerMah);
        app.bluetoothRunningTimeMs = Math.max(0L, totalTimeMs - this.mAppTotalTimeMs);
    }

    @Override
    public void reset() {
        this.mAppTotalPowerMah = 0.0;
        this.mAppTotalTimeMs = 0L;
    }
}

