/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import com.android.layoutlib.bridge.util.SparseWeakArray;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class DelegateManager<T> {
    private final Class<T> mClass;
    private static final SparseWeakArray<Object> sDelegates = new SparseWeakArray();
    private static final Set<Object> sJavaReferences = new HashSet<Object>();
    private static final AtomicLong sDelegateCounter = new AtomicLong(1L);

    public DelegateManager(Class<T> theClass) {
        this.mClass = theClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getDelegate(long native_object) {
        if (native_object > 0L) {
            Class<DelegateManager> clazz = DelegateManager.class;
            synchronized (DelegateManager.class) {
                Object delegate = sDelegates.get(native_object);
                // ** MonitorExit[var4_2] (shouldn't be in output)
                assert (delegate != null);
                return (T)delegate;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addNewDelegate(T newDelegate) {
        long native_object = sDelegateCounter.getAndIncrement();
        Class<DelegateManager> clazz = DelegateManager.class;
        synchronized (DelegateManager.class) {
            sDelegates.put(native_object, newDelegate);
            sJavaReferences.add(newDelegate);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return native_object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJavaReferenceFor(long native_object) {
        Class<DelegateManager> clazz = DelegateManager.class;
        synchronized (DelegateManager.class) {
            T delegate = this.getDelegate(native_object);
            sJavaReferences.remove(delegate);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void dump(PrintStream out) {
        for (Object reference : sJavaReferences) {
            int idx = sDelegates.indexOfValue(reference);
            out.printf("[%d] %s\n", sDelegates.keyAt(idx), reference.getClass().getSimpleName());
        }
        out.printf("\nTotal number of objects: %d\n", sJavaReferences.size());
    }
}

