/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.codeInsight.template.impl.DefaultLiveTemplatesProvider;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.spring.metadata.SpringStereotypeQualifierMetaData;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.ArrayUtil;

public class SpringResourceProvider
implements StandardResourceProvider,
DefaultLiveTemplatesProvider,
MetaDataContributor {
    public void registerResources(ResourceRegistrar registrar) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            registrar.addStdResource("http://www.springframework.org/dtd/spring-beans.dtd", "/resources/dtd/spring-beans.dtd", this.getClass());
            registrar.addStdResource("http://www.springframework.org/dtd/spring-beans-2.0.dtd", "/resources/dtd/spring-beans-2.0.dtd", this.getClass());
        }
    }

    public String[] getDefaultLiveTemplateFiles() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getHiddenLiveTemplateFiles() {
        return new String[]{"/liveTemplates/spring", "/liveTemplates/aop", "/liveTemplates/dataAccess", "/liveTemplates/scheduling", "/liveTemplates/integration", "/liveTemplates/commonBeans", "/liveTemplates/webflow", "/liveTemplates/osgi"};
    }

    public void contributeMetaData(MetaDataRegistrar registrar) {
        registrar.registerMetaData(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                Module module;
                if (element instanceof PsiAnnotation && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null) {
                    for (PsiClass psiClass : JamAnnotationTypeUtil.getInstance((Module)module).getQualifierAnnotationTypesWithChildren()) {
                        PsiAnnotation annotation = (PsiAnnotation)element;
                        if (!Comparing.equal((String)annotation.getQualifiedName(), (String)psiClass.getQualifiedName())) continue;
                        return true;
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return PsiAnnotation.class.isAssignableFrom(hintClass);
            }
        }, SpringStereotypeQualifierMetaData.class);
    }
}

