/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.beans;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelsDataModel;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleLocalModelWrapper
extends LocalModelGraphElementWrapper<Module> {
    private static final String MODULE_PREFIX = "module=";

    protected ModuleLocalModelWrapper(@NotNull Module element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/contexts/model/diagram/beans/ModuleLocalModelWrapper", "<init>"));
        }
        super(element);
    }

    @Override
    public String getTitle() {
        return ((Module)this.myElement).getName();
    }

    @Override
    public String getToolTip() {
        return "";
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Module;
    }

    @Override
    public String getQualifiedName() {
        return MODULE_PREFIX + ((Module)this.myElement).getName();
    }

    public static LocalModelGraphElementWrapper resolveByFQN(String fqn, Project project) {
        if (fqn.startsWith(MODULE_PREFIX)) {
            String name = fqn.substring(MODULE_PREFIX.length());
            Module module = ModuleManager.getInstance((Project)project).findModuleByName(name);
            if (module == null) {
                throw new IllegalArgumentException(String.format("Wrong module FQN '%s'", fqn));
            }
            return new ModuleLocalModelWrapper(module);
        }
        return null;
    }

    public static LocalModelGraphElementWrapper create(@Nullable Module module) {
        return module == null ? null : new ModuleLocalModelWrapper(module);
    }

    @Override
    public void accept(@NotNull SpringLocalModelsDataModel.RelatedVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/spring/contexts/model/diagram/beans/ModuleLocalModelWrapper", "accept"));
        }
        visitor.visitModule((Module)this.myElement);
    }
}

