/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetMapper;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringStereotypeAliasingPsiTargetMapper
implements AliasingPsiTargetMapper {
    @NotNull
    public Set<AliasingPsiTarget> getTargets(final @NotNull PomTarget psiTarget) {
        if (psiTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiTarget", "com/intellij/spring/model/jam/stereotype/SpringStereotypeAliasingPsiTargetMapper", "getTargets"));
        }
        if (!(psiTarget instanceof PsiClass)) {
            Set<AliasingPsiTarget> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringStereotypeAliasingPsiTargetMapper", "getTargets"));
            }
            return set;
        }
        Set set = (Set)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Set<AliasingPsiTarget>>(){

            public Set<AliasingPsiTarget> compute() {
                PsiClass psiClass = (PsiClass)psiTarget;
                return (Set)DumbService.getInstance((Project)psiClass.getProject()).runReadActionInSmartMode(() -> {
                    if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass)) {
                        return Collections.emptySet();
                    }
                    SpringStereotypeElement stereotypeElement = SpringJamUtils.getInstance().findStereotypeElement(psiClass);
                    if (stereotypeElement != null && stereotypeElement.getPsiTarget() instanceof AliasingPsiTarget) {
                        return Collections.singleton((AliasingPsiTarget)stereotypeElement.getPsiTarget());
                    }
                    return Collections.emptySet();
                });
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/stereotype/SpringStereotypeAliasingPsiTargetMapper", "getTargets"));
        }
        return set;
    }
}

