/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInsight.daemon.quickFix.CreateClassOrPackageFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringBeanPointerResolveInspection;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtilImpl;
import com.intellij.spring.model.jam.testContexts.SpringTransactionConfiguration;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSql;
import com.intellij.spring.model.jam.testContexts.jdbc.SpringTestingSqlConfig;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringContextConfigurationInspection
extends BaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection", "checkClass"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module != null) {
            SpringTestingSqlConfig sqlConfig;
            SpringTransactionConfiguration transactionConfiguration;
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            SpringContextConfiguration contextConfiguration = (SpringContextConfiguration)SpringContextConfiguration.META.getJamElement((PsiModifierListOwner)aClass);
            if (contextConfiguration != null) {
                SpringContextConfigurationInspection.checkContextConfiguration(contextConfiguration, holder);
            }
            if ((transactionConfiguration = (SpringTransactionConfiguration)SpringTransactionConfiguration.META.getJamElement((PsiModifierListOwner)aClass)) != null) {
                SpringBeanPointerResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, transactionConfiguration.getTransactionManagerAttributeElement(), (String)"org.springframework.transaction.PlatformTransactionManager");
            }
            if ((sqlConfig = this.getTestingSqlConfig(aClass)) != null) {
                SpringBeanPointerResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, (JamStringAttributeElement)sqlConfig.getTransactionManagerElement(), (String)"org.springframework.transaction.PlatformTransactionManager");
                SpringBeanPointerResolveInspection.checkBeanPointerResolve((ProblemsHolder)holder, (JamStringAttributeElement)sqlConfig.getDatasourceAttrElement(), (String)"javax.sql.DataSource");
            }
            return holder.getResultsArray();
        }
        return super.checkClass(aClass, manager, isOnTheFly);
    }

    protected SpringTestingSqlConfig getTestingSqlConfig(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection", "getTestingSqlConfig"));
        }
        SpringTestingSqlConfig sqlConfig = (SpringTestingSqlConfig)SpringTestingSqlConfig.META.getJamElement((PsiModifierListOwner)aClass);
        if (sqlConfig != null) {
            return sqlConfig;
        }
        SpringTestingSql testingSql = (SpringTestingSql)SpringTestingSql.CLASS_META.getJamElement((PsiModifierListOwner)aClass);
        if (testingSql != null) {
            return testingSql.getSqlConfig();
        }
        return null;
    }

    private static void checkContextConfiguration(@NotNull SpringContextConfiguration contextConfiguration, @NotNull ProblemsHolder holder) {
        XmlFile xmlFile;
        if (contextConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextConfiguration", "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection", "checkContextConfiguration"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection", "checkContextConfiguration"));
        }
        if (SpringContextConfigurationInspection.isLocationsAttributesDefined(contextConfiguration, true)) {
            SpringContextConfigurationInspection.checkLocationAttribute(holder, contextConfiguration.getLocationsAttributeElement());
            SpringContextConfigurationInspection.checkLocationAttribute(holder, contextConfiguration.getValueAttributeElement());
        } else if (SpringTestContextUtilImpl.isGenericXmlContextLoader(contextConfiguration) && (xmlFile = SpringTestContextUtilImpl.getDefaultLocation((ContextConfiguration)contextConfiguration)) == null) {
            final PsiAnnotation annotation = contextConfiguration.getAnnotation();
            assert (annotation != null);
            PsiDirectory directory = annotation.getContainingFile().getContainingDirectory();
            CreateFileFix fix = directory == null ? null : new CreateFileFix(SpringTestContextUtilImpl.getDefaultAppContextName((ContextConfiguration)contextConfiguration), directory, null){

                protected String getFileText() {
                    return SpringCommonUtils.getSpringXmlTemplate((Module[])new Module[]{ModuleUtilCore.findModuleForPsiElement((PsiElement)annotation)}).getText();
                }
            };
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("SpringContextConfigurationInspection.cannot.find.default.app.context", SpringTestContextUtilImpl.getDefaultAppContextName((ContextConfiguration)contextConfiguration)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
        }
        if (SpringTestContextUtilImpl.isAnnotationConfigLoader((ContextConfiguration)contextConfiguration)) {
            PsiClass psiClass;
            CommonProcessors.FindFirstProcessor<SpringContextConfiguration> processor = new CommonProcessors.FindFirstProcessor<SpringContextConfiguration>(){

                protected boolean accept(SpringContextConfiguration configuration) {
                    return configuration.getConfigurationClasses().size() != 0;
                }
            };
            SpringContextConfigurationInspection.processConfigurations(contextConfiguration, true, (Processor<SpringContextConfiguration>)processor);
            if (!processor.isFound() && (psiClass = SpringTestContextUtilImpl.getDefaultConfiguration((ContextConfiguration)contextConfiguration)) == null) {
                PsiAnnotation annotation = contextConfiguration.getAnnotation();
                assert (annotation != null);
                PsiClass aClass = contextConfiguration.getPsiElement();
                String defaultConfigurationName = aClass.getQualifiedName() + "ContextConfiguration";
                String packageName = ClassUtil.extractPackageName((String)aClass.getQualifiedName());
                CreateClassOrPackageFix fix = CreateClassOrPackageFix.createFix((String)defaultConfigurationName, (GlobalSearchScope)aClass.getResolveScope(), (PsiElement)aClass, (PsiPackage)JavaPsiFacade.getInstance((Project)aClass.getProject()).findPackage(packageName), (ClassKind)ClassKind.CLASS, null, null);
                holder.registerProblem((PsiElement)annotation, SpringBundle.message("SpringContextConfigurationInspection.cannot.find.default.app.context", aClass.getName() + "ContextConfiguration"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{holder.isOnTheFly() ? fix : null});
            }
        }
    }

    private static void checkLocationAttribute(ProblemsHolder holder, List<JamStringAttributeElement<List<XmlFile>>> attributeElements) {
        block0: for (JamStringAttributeElement<List<XmlFile>> attributeElement : attributeElements) {
            PsiLiteral psiLiteral = attributeElement.getPsiLiteral();
            if (psiLiteral == null) continue;
            for (PsiReference psiReference : psiLiteral.getReferences()) {
                if (psiReference.isSoft() || !(psiReference instanceof FileReference) || ((FileReference)psiReference).multiResolve(false).length != 0) continue;
                holder.registerProblem(psiReference);
                continue block0;
            }
        }
    }

    private static boolean isLocationsAttributesDefined(SpringContextConfiguration contextConfiguration) {
        return !contextConfiguration.getLocationsAttributeElement().isEmpty() || !contextConfiguration.getValueAttributeElement().isEmpty();
    }

    private static boolean isLocationsAttributesDefined(SpringContextConfiguration contextConfiguration, boolean searchParent) {
        CommonProcessors.FindFirstProcessor<SpringContextConfiguration> searchLocationsProcessor = new CommonProcessors.FindFirstProcessor<SpringContextConfiguration>(){

            protected boolean accept(SpringContextConfiguration configuration) {
                return SpringContextConfigurationInspection.isLocationsAttributesDefined(configuration);
            }
        };
        SpringContextConfigurationInspection.processConfigurations(contextConfiguration, searchParent, (Processor<SpringContextConfiguration>)searchLocationsProcessor);
        return searchLocationsProcessor.isFound();
    }

    private static boolean processConfigurations(@NotNull SpringContextConfiguration contextConfiguration, boolean searchParent, @NotNull Processor<SpringContextConfiguration> processor) {
        PsiClass psiClass;
        if (contextConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextConfiguration", "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection", "processConfigurations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection", "processConfigurations"));
        }
        if (!processor.process((Object)contextConfiguration)) {
            return false;
        }
        if (searchParent && (psiClass = contextConfiguration.getPsiElement()) != null) {
            JamService service = JamService.getJamService((Project)psiClass.getProject());
            for (PsiClass superClass = psiClass.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                SpringContextConfiguration configuration = (SpringContextConfiguration)service.getJamElement((PsiElement)superClass, new JamMemberMeta[]{SpringContextConfiguration.META});
                if (configuration == null || processor.process((Object)configuration)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringContextConfigurationInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringContextConfigurationInspection", "getShortName"));
        }
        return "SpringContextConfigurationInspection";
    }
}

