/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringTestingTransactionalInspection
extends BaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/spring/model/jam/testContexts/SpringTestingTransactionalInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/model/jam/testContexts/SpringTestingTransactionalInspection", "checkClass"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module != null && (SpringTestContextUtil.getInstance().isTestContextConfigurationClass(aClass) || ApplicationManager.getApplication().isUnitTestMode())) {
            ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
            for (PsiMethod method : aClass.getMethods()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.springframework.test.context.transaction.BeforeTransaction", "org.springframework.test.context.transaction.AfterTransaction"});
                if (annotation == null) continue;
                SpringTestingTransactionalInspection.checkLifecycleTransactionMethod(holder, method, annotation);
            }
            return holder.getResultsArray();
        }
        return super.checkClass(aClass, manager, isOnTheFly);
    }

    private static void checkLifecycleTransactionMethod(@NotNull ProblemsHolder holder, @NotNull PsiMethod method, @NotNull PsiAnnotation annotation) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/jam/testContexts/SpringTestingTransactionalInspection", "checkLifecycleTransactionMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/model/jam/testContexts/SpringTestingTransactionalInspection", "checkLifecycleTransactionMethod"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/model/jam/testContexts/SpringTestingTransactionalInspection", "checkLifecycleTransactionMethod"));
        }
        if (method.getParameterList().getParametersCount() > 0) {
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("spring.testing.transactional.wrong.number.of.arguments.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
        if (!PsiType.VOID.equals((Object)method.getReturnType())) {
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("spring.testing.transactional.void.method.return.type.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringTestingTransactionalInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/SpringTestingTransactionalInspection", "getShortName"));
        }
        return "SpringTestingTransactionalInspection";
    }
}

