/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.wrappers;

import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.wrappers.WModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WFileset {
    @NotNull
    public final String name;
    @NotNull
    public final ArrayList<WModel> models;
    @NotNull
    private final Set<String> activeProfiles;
    @NotNull
    private final List<String> dependencyFileSets;
    @NotNull
    private final List<String> propertiesFiles;
    private final boolean autodetected;
    private final boolean removed;

    public WFileset(@NotNull String name, @NotNull Set<String> activeProfiles, @NotNull List<String> dependencyFileSets, @NotNull List<String> propertiesFiles, boolean autodetected, boolean removed) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/model/wrappers/WFileset", "<init>"));
        }
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/model/wrappers/WFileset", "<init>"));
        }
        if (dependencyFileSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyFileSets", "com/intellij/spring/model/wrappers/WFileset", "<init>"));
        }
        if (propertiesFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFiles", "com/intellij/spring/model/wrappers/WFileset", "<init>"));
        }
        this.models = new ArrayList();
        this.name = name;
        this.activeProfiles = activeProfiles;
        this.dependencyFileSets = dependencyFileSets;
        this.propertiesFiles = propertiesFiles;
        this.autodetected = autodetected;
        this.removed = removed;
    }

    public WFileset(@NotNull SpringFileSet fileSet) {
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/model/wrappers/WFileset", "<init>"));
        }
        this.models = new ArrayList();
        this.name = fileSet.getName();
        this.activeProfiles = fileSet.getActiveProfiles();
        this.dependencyFileSets = ContainerUtil.map((Collection)fileSet.getDependencyFileSets(), SpringFileSet::getName);
        this.propertiesFiles = ContainerUtil.map((Collection)fileSet.getPropertiesFiles(), VirtualFilePointer::getFileName);
        this.autodetected = fileSet.isAutodetected();
        this.removed = fileSet.isRemoved();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WFileset set = (WFileset)o;
        if (!this.name.equals(set.name)) {
            return false;
        }
        return this.models.equals(set.models);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.models.hashCode();
        return result;
    }
}

