/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.folding;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CfmlFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/UI/folding/CfmlFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/folding/CfmlFoldingBuilder", "buildFoldRegions"));
        }
        PsiElement element = node.getPsi();
        if (element instanceof CfmlFile) {
            CfmlFile file = (CfmlFile)element;
            PsiElement[] children = file.getChildren();
            LinkedList<FoldingDescriptor> result = new LinkedList<FoldingDescriptor>();
            for (PsiElement child : children) {
                if (child == null || !(child instanceof CfmlCompositeElement) && !(child instanceof PsiComment)) continue;
                ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
                CfmlFoldingBuilder.addFoldingDescriptors(descriptors, child, document);
                result.addAll(descriptors);
            }
            FoldingDescriptor[] foldingDescriptorArray = result.toArray(FoldingDescriptor.EMPTY);
            if (foldingDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/folding/CfmlFoldingBuilder", "buildFoldRegions"));
            }
            return foldingDescriptorArray;
        }
        if (FoldingDescriptor.EMPTY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/folding/CfmlFoldingBuilder", "buildFoldRegions"));
        }
        return FoldingDescriptor.EMPTY;
    }

    private static void addFoldingDescriptorsFromChildren(List<FoldingDescriptor> descriptors, PsiElement tag, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/folding/CfmlFoldingBuilder", "addFoldingDescriptorsFromChildren"));
        }
        for (PsiElement child = tag.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof CfmlCompositeElement) && !(child instanceof PsiComment)) continue;
            CfmlFoldingBuilder.addFoldingDescriptors(descriptors, child, document);
        }
    }

    private static void addFoldingDescriptors(List<FoldingDescriptor> descriptors, PsiElement tag, @NotNull Document document) {
        int end;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/coldFusion/UI/folding/CfmlFoldingBuilder", "addFoldingDescriptors"));
        }
        TextRange elementRange = tag.getTextRange();
        int start = elementRange.getStartOffset();
        if (start + 1 < (end = elementRange.getEndOffset())) {
            TextRange range = null;
            ASTNode astNode = tag.getNode();
            IElementType astType = astNode.getElementType();
            if (tag instanceof CfmlTag) {
                range = CfmlFoldingBuilder.buildRangeForBraces(range, astNode, CfmlTokenTypes.R_ANGLEBRACKET, CfmlTokenTypes.LSLASH_ANGLEBRACKET);
            } else if (astType == CfmlElementTypes.FUNCTIONBODY || astType == CfmlElementTypes.BLOCK_OF_STATEMENTS) {
                range = CfmlFoldingBuilder.buildRange(range, start, end);
            } else if (astType == CfmlElementTypes.SWITCHEXPRESSION) {
                ASTNode lparen = astNode.findChildByType(CfscriptTokenTypes.L_CURLYBRACKET);
                ASTNode rparen = astNode.findChildByType(CfscriptTokenTypes.R_CURLYBRACKET);
                if (lparen != null && rparen != null) {
                    range = CfmlFoldingBuilder.buildRange(range, lparen.getStartOffset(), rparen.getTextRange().getEndOffset());
                }
            } else if (tag instanceof PsiComment) {
                String commentText;
                boolean isColdFusionComment = astNode.getElementType() == CfmlTokenTypes.COMMENT;
                int endIndex = astNode.getText().lastIndexOf(isColdFusionComment ? "--->" : "*/");
                if (endIndex != -1 && (commentText = astNode.getText().substring(0, endIndex)).contains("\n")) {
                    int startOffset = tag.getTextRange().getStartOffset();
                    range = CfmlFoldingBuilder.buildRange(range, startOffset + (isColdFusionComment ? "<!---" : "/*").length(), startOffset + commentText.length());
                }
            }
            if (range != null) {
                descriptors.add(new FoldingDescriptor(astNode, range));
            }
            CfmlFoldingBuilder.addFoldingDescriptorsFromChildren(descriptors, tag, document);
        }
    }

    private static TextRange buildRangeForBraces(TextRange range, @NotNull ASTNode astNode, IElementType lbraceType, IElementType rbraceType) {
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/coldFusion/UI/folding/CfmlFoldingBuilder", "buildRangeForBraces"));
        }
        ASTNode lBrace = astNode.findChildByType(lbraceType);
        ASTNode rBrace = astNode.findChildByType(rbraceType);
        if (lBrace != null && rBrace != null) {
            range = CfmlFoldingBuilder.buildRange(range, lBrace.getStartOffset() + 1, rBrace.getStartOffset());
        }
        return range;
    }

    private static TextRange buildRange(TextRange range, int leftOffset, int rightOffset) {
        if (leftOffset + 1 < rightOffset) {
            range = new TextRange(leftOffset, rightOffset);
        }
        return range;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/UI/folding/CfmlFoldingBuilder", "getPlaceholderText"));
        }
        IElementType type = node.getElementType();
        if (type == CfmlElementTypes.FUNCTIONBODY || type == CfmlElementTypes.BLOCK_OF_STATEMENTS || type == CfmlElementTypes.SWITCHEXPRESSION) {
            return "{...}";
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/UI/folding/CfmlFoldingBuilder", "isCollapsedByDefault"));
        }
        CodeFoldingSettings settings = CodeFoldingSettings.getInstance();
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
        if (element instanceof PsiComment) {
            ASTNode parent = node.getTreeParent();
            ASTNode treePrev = node.getTreePrev();
            if (parent.getElementType() == CfmlElementTypes.CFML_FILE && treePrev == null) {
                return CodeFoldingSettings.getInstance().COLLAPSE_FILE_HEADER;
            }
            return CodeFoldingSettings.getInstance().COLLAPSE_DOC_COMMENTS;
        }
        if (element instanceof CfmlFunction || node.getElementType() == CfmlElementTypes.FUNCTIONBODY) {
            return settings.COLLAPSE_METHODS;
        }
        return false;
    }
}

