/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.runner;

import com.intellij.coldFusion.UI.runner.CfmlRunConfigurationEditor;
import com.intellij.coldFusion.UI.runner.CfmlRunnerParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlRunConfiguration
extends RunConfigurationBase
implements LocatableConfiguration {
    private CfmlRunnerParameters myRunnerParameters = new CfmlRunnerParameters();
    private boolean fromDefaultHost = false;

    protected CfmlRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        CfmlRunConfigurationEditor cfmlRunConfigurationEditor = new CfmlRunConfigurationEditor();
        if (cfmlRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/runner/CfmlRunConfiguration", "getConfigurationEditor"));
        }
        return cfmlRunConfigurationEditor;
    }

    protected CfmlRunnerParameters createRunnerParametersInstance() {
        return new CfmlRunnerParameters();
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunnerParameters = this.createRunnerParametersInstance();
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myRunnerParameters != null) {
            XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
        }
    }

    public RunConfiguration clone() {
        CfmlRunConfiguration clone = (CfmlRunConfiguration)super.clone();
        clone.myRunnerParameters = this.myRunnerParameters.clone();
        return clone;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/coldFusion/UI/runner/CfmlRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/coldFusion/UI/runner/CfmlRunConfiguration", "getState"));
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public static void checkURL(String url) throws RuntimeConfigurationException {
        try {
            if (url == null) {
                throw new MalformedURLException("No start file specified or this file is invalid");
            }
            new URL(url);
        }
        catch (MalformedURLException ignored) {
            throw new RuntimeConfigurationError("Incorrect URL");
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        CfmlRunConfiguration.checkURL(this.myRunnerParameters.getUrl());
    }

    public CfmlRunnerParameters getRunnerParameters() {
        return this.myRunnerParameters;
    }

    public boolean isGeneratedName() {
        return Comparing.equal((String)this.getName(), (String)this.suggestedName());
    }

    @Nullable
    public String suggestedName() {
        String path = this.getRunnerParameters().getUrl();
        return StringUtil.isNotEmpty((String)path) ? PathUtil.getFileName((String)path) : "";
    }

    public void setFromDefaultHost(boolean generatedFromDefaultHost) {
        this.fromDefaultHost = generatedFromDefaultHost;
    }

    public boolean isFromDefaultHost() {
        return this.fromDefaultHost;
    }
}

