/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.runner;

import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.UI.runner.CfmlRunConfiguration;
import com.intellij.coldFusion.UI.runner.CfmlRunnerParameters;
import com.intellij.coldFusion.mxunit.CfmlUnitRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class CfmlRunner
extends GenericProgramRunner {
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/coldFusion/UI/runner/CfmlRunner", "doExecute"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/coldFusion/UI/runner/CfmlRunner", "doExecute"));
        }
        RunProfile runProfileRaw = env.getRunProfile();
        if (runProfileRaw instanceof CfmlRunConfiguration) {
            FileDocumentManager.getInstance().saveAllDocuments();
            CfmlRunConfiguration runProfile = (CfmlRunConfiguration)runProfileRaw;
            if (runProfile.isFromDefaultHost()) {
                CfmlRunner.showDefaultRunConfigWarn(env, runProfile);
            } else {
                CfmlRunnerParameters params = runProfile.getRunnerParameters();
                BrowserLauncher.getInstance().browse(params.getUrl(), params.getCustomBrowser(), env.getProject());
            }
            return null;
        }
        return DefaultProgramRunnerKt.executeState((RunProfileState)state, (ExecutionEnvironment)env, (ProgramRunner)this);
    }

    @NotNull
    public String getRunnerId() {
        if ("CfmlRunner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/UI/runner/CfmlRunner", "getRunnerId"));
        }
        return "CfmlRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/coldFusion/UI/runner/CfmlRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/coldFusion/UI/runner/CfmlRunner", "canRun"));
        }
        return DefaultRunExecutor.EXECUTOR_ID.equals(executorId) && (profile instanceof CfmlRunConfiguration || profile instanceof CfmlUnitRunConfiguration);
    }

    private static void showDefaultRunConfigWarn(@NotNull ExecutionEnvironment env, CfmlRunConfiguration runProfile) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/coldFusion/UI/runner/CfmlRunner", "showDefaultRunConfigWarn"));
        }
        DialogBuilder db = new DialogBuilder(env.getProject());
        JLabel info = new JLabel(CfmlBundle.message("cfml.runconfig.dialog.template.label", new Object[0]));
        info.setMaximumSize(new Dimension(400, 500));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 2));
        JLabel webPathLabel = new JLabel(CfmlBundle.message("cfml.runconfig.editor.server.url", new Object[0]));
        JTextField webPathField = new JTextField(runProfile.getRunnerParameters().getUrl());
        centerPanel.add(webPathLabel);
        centerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        centerPanel.add(webPathField);
        info.setIcon(UIUtil.getWarningIcon());
        db.setNorthPanel((JComponent)info);
        db.setCenterPanel((JComponent)centerPanel);
        db.setPreferredFocusComponent((JComponent)info);
        db.setTitle(CfmlBundle.message("cfml.runconfig.dialog.template.title", new Object[0]));
        db.addOkAction().setText(CfmlBundle.message("cfml.runconfig.dialog.template.button.run", new Object[0]));
        db.addCancelAction().setText(CfmlBundle.message("cfml.runconfig.dialog.template.button.cancel", new Object[0]));
        db.setOkOperation(() -> {
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/coldFusion/UI/runner/CfmlRunner", "lambda$showDefaultRunConfigWarn$0"));
            }
            runProfile.setFromDefaultHost(false);
            CfmlRunnerParameters params = runProfile.getRunnerParameters();
            RunnerAndConfigurationSettings configurationTemplate = RunManager.getInstance((Project)env.getProject()).getConfigurationTemplate(runProfile.getFactory());
            ((CfmlRunConfiguration)configurationTemplate.getConfiguration()).getRunnerParameters().setUrl(webPathField.getText());
            BrowserLauncher.getInstance().browse(params.getUrl(), params.getCustomBrowser(), env.getProject());
            db.getDialogWrapper().close(0);
        });
        db.show();
    }
}

