/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.parsers;

import com.intellij.coldFusion.CfmlBundle;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.parsers.CfmlExpressionParser;
import com.intellij.coldFusion.model.parsers.CfscriptParser;
import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlParser
implements PsiParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.coldFusion.model.parsers.CfmlParser");

    public static IElementType getElementTypeForTag(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/coldFusion/model/parsers/CfmlParser", "getElementTypeForTag"));
        }
        if ("cfcomponent".equals(tagName.toLowerCase()) || "cfinterface".equals(tagName.toLowerCase())) {
            return CfmlElementTypes.COMPONENT_TAG;
        }
        if ("cffunction".equals(tagName.toLowerCase())) {
            return CfmlElementTypes.FUNCTION_TAG;
        }
        if ("cfinvoke".equals(tagName.toLowerCase())) {
            return CfmlElementTypes.INVOKE_TAG;
        }
        if ("cfargument".equals(tagName.toLowerCase())) {
            return CfmlElementTypes.ARGUMENT_TAG;
        }
        if ("cfscript".equals(tagName.toLowerCase())) {
            return CfmlElementTypes.SCRIPT_TAG;
        }
        if ("cfproperty".equals(tagName.toLowerCase())) {
            return CfmlElementTypes.PROPERTY_TAG;
        }
        if ("cfimport".equals(tagName.toLowerCase())) {
            return CfmlElementTypes.TAG_IMPORT;
        }
        if ("cfloop".endsWith(tagName.toLowerCase())) {
            return CfmlElementTypes.FORTAGEXPRESSION;
        }
        return CfmlElementTypes.TAG;
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        Stack tagNamesStack = new Stack();
        PsiBuilder.Marker marker = builder.mark();
        if (builder.getTokenType() == CfscriptTokenTypes.COMMENT || builder.getTokenType() == CfscriptTokenTypes.COMPONENT_KEYWORD || builder.getTokenType() == CfscriptTokenTypes.INTERFACE_KEYWORD || builder.getTokenType() == CfscriptTokenTypes.IMPORT_KEYWORD) {
            new CfscriptParser().parseScript(builder, true);
            if (!builder.eof()) {
                builder.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
            }
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        } else {
            while (!builder.eof()) {
                if (builder.getTokenType() == CfmlTokenTypes.OPENER) {
                    CfmlParser.parseOpenTag(builder, (Stack<Tag>)tagNamesStack);
                    continue;
                }
                if (builder.getTokenType() == CfmlTokenTypes.LSLASH_ANGLEBRACKET) {
                    CfmlParser.parseCloseTag(builder, (Stack<Tag>)tagNamesStack);
                    continue;
                }
                builder.advanceLexer();
            }
            while (!tagNamesStack.isEmpty()) {
                Tag tag = (Tag)tagNamesStack.pop();
                if (CfmlUtil.isUserDefined(tag.myTagName) || !CfmlUtil.isEndTagRequired(tag.myTagName, builder.getProject())) {
                    tag.myMarkerOfBegin.doneBefore(CfmlParser.getElementTypeForTag(tag.myTagName), tag.myMarkerOfContent);
                } else {
                    tag.myMarkerOfBegin.doneBefore(CfmlParser.getElementTypeForTag(tag.myTagName), tag.myMarkerOfContent, CfmlBundle.message("cfml.parsing.element.is.not.closed", tag.myTagName));
                }
                tag.myMarkerOfContent.drop();
            }
        }
        marker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/parsers/CfmlParser", "parse"));
        }
        return aSTNode;
    }

    private static void parseExpression(PsiBuilder builder) {
        if (builder.getTokenType() != CfmlTokenTypes.START_EXPRESSION) {
            return;
        }
        builder.advanceLexer();
        if (!new CfmlExpressionParser(builder).parseStructureDefinition() && !new CfmlExpressionParser(builder).parseArrayDefinition()) {
            new CfmlExpressionParser(builder).parseExpression();
        }
        if (builder.getTokenType() != CfmlTokenTypes.END_EXPRESSION) {
            builder.error(CfmlBundle.message("cfml.parsing.expression.unclosed", new Object[0]));
        } else if (!builder.eof()) {
            builder.advanceLexer();
        }
    }

    private static void readValue(PsiBuilder builder, IElementType typeOfValue) {
        if (typeOfValue != null) {
            if (builder.getTokenType() == CfmlTokenTypes.SINGLE_QUOTE || builder.getTokenType() == CfmlTokenTypes.DOUBLE_QUOTE) {
                builder.advanceLexer();
                PsiBuilder.Marker marker = builder.mark();
                int valueStartOffset = builder.getCurrentOffset();
                while (!builder.eof() && builder.getTokenType() != CfmlTokenTypes.SINGLE_QUOTE_CLOSER && builder.getTokenType() != CfmlTokenTypes.DOUBLE_QUOTE_CLOSER && !CfmlUtil.isControlToken(builder.getTokenType())) {
                    if (builder.getTokenType() == CfmlTokenTypes.START_EXPRESSION) {
                        CfmlParser.parseExpression(builder);
                        continue;
                    }
                    builder.advanceLexer();
                }
                if (builder.getCurrentOffset() != valueStartOffset) {
                    marker.done(typeOfValue);
                } else {
                    marker.drop();
                }
                if (builder.getTokenType() != CfmlTokenTypes.SINGLE_QUOTE_CLOSER && builder.getTokenType() != CfmlTokenTypes.DOUBLE_QUOTE_CLOSER) {
                    builder.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
                } else {
                    builder.advanceLexer();
                }
                return;
            }
            if (!CfmlUtil.isControlToken(builder.getTokenType()) && builder.getTokenType() != CfmlTokenTypes.ATTRIBUTE) {
                new CfmlExpressionParser(builder).parseExpression();
                return;
            }
        }
        while (!builder.eof() && !CfmlUtil.isControlToken(builder.getTokenType()) && builder.getTokenType() != CfmlTokenTypes.ATTRIBUTE) {
            if (builder.getTokenType() == CfmlTokenTypes.START_EXPRESSION) {
                CfmlParser.parseExpression(builder);
                continue;
            }
            builder.advanceLexer();
        }
    }

    private static boolean doNeedNamedAttribute(String tagName) {
        if (tagName == null) {
            return false;
        }
        return !tagName.toLowerCase().equals("cffunction") && !tagName.toLowerCase().equals("cfargument");
    }

    public static void parseAttributes(PsiBuilder builder, String tagName, IElementType attributeType, boolean strict) {
        if (tagName.equals("cfset")) {
            new CfmlExpressionParser(builder).parseStatement();
            return;
        }
        if (tagName.equals("cfif") || tagName.equals("cfelseif") || tagName.equals("cfreturn")) {
            new CfmlExpressionParser(builder).parseExpression();
            return;
        }
        while (!builder.eof() && !CfmlUtil.isControlToken(builder.getTokenType())) {
            if (builder.getTokenType() == attributeType || builder.getTokenType() == CfscriptTokenTypes.DEFAULT_KEYWORD || tagName.equalsIgnoreCase("cfproperty") && builder.getTokenType() == CfscriptTokenTypes.ABORT_KEYWORD) {
                String attributeName = builder.getTokenText().toLowerCase();
                PsiBuilder.Marker attrMarker = builder.mark();
                builder.advanceLexer();
                if (builder.getTokenType() != CfmlTokenTypes.ASSIGN) {
                    attrMarker.done((IElementType)CfmlElementTypes.ATTRIBUTE);
                    builder.error(CfmlBundle.message("cfml.parsing.no.value", new Object[0]));
                    continue;
                }
                builder.advanceLexer();
                if ("name".equals(attributeName)) {
                    CfmlParser.readValue(builder, CfmlElementTypes.ATTRIBUTE_VALUE);
                    if (CfmlParser.doNeedNamedAttribute(tagName)) {
                        attrMarker.done((IElementType)CfmlElementTypes.NAMED_ATTRIBUTE);
                        continue;
                    }
                    attrMarker.done((IElementType)CfmlElementTypes.ATTRIBUTE_NAME);
                    continue;
                }
                if ("method".equals(attributeName) && "cfinvoke".equals(tagName)) {
                    CfmlParser.readValue(builder, CfmlElementTypes.REFERENCE_EXPRESSION);
                    attrMarker.done((IElementType)CfmlElementTypes.TAG_FUNCTION_CALL);
                    continue;
                }
                if ("index".equals(attributeName) && "cfloop".equals(tagName)) {
                    CfmlParser.readValue(builder, CfmlElementTypes.ATTRIBUTE_VALUE);
                    attrMarker.done(CfmlElementTypes.FORTAGINDEXATTRIBUTE);
                    continue;
                }
                CfmlParser.readValue(builder, CfmlElementTypes.ATTRIBUTE_VALUE);
                attrMarker.done((IElementType)CfmlElementTypes.ATTRIBUTE);
                continue;
            }
            if (strict) {
                return;
            }
            builder.advanceLexer();
        }
    }

    private static boolean parseCloser(PsiBuilder builder) {
        if (!builder.eof() && !CfmlUtil.isControlToken(builder.getTokenType())) {
            builder.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
            builder.advanceLexer();
            while (!builder.eof() && !CfmlUtil.isControlToken(builder.getTokenType())) {
                builder.advanceLexer();
            }
        }
        if (builder.getTokenType() == CfmlTokenTypes.CLOSER) {
            builder.advanceLexer();
            return true;
        }
        builder.error(CfmlBundle.message("cfml.parsing.tag.is.not.done", new Object[0]));
        return false;
    }

    private static boolean parseCloseTag(PsiBuilder builder, Stack<Tag> tagNamesStack) {
        builder.advanceLexer();
        if (builder.getTokenType() == CfmlTokenTypes.CF_TAG_NAME) {
            String closeTagName = builder.getTokenText().toLowerCase();
            builder.advanceLexer();
            boolean canParse = false;
            for (Tag t : tagNamesStack) {
                if (!t.myTagName.equals(closeTagName)) continue;
                canParse = true;
                break;
            }
            if (canParse) {
                Tag tag = null;
                while (!tagNamesStack.empty()) {
                    tag = (Tag)tagNamesStack.pop();
                    if (tag.myTagName.equals(closeTagName)) break;
                    if (CfmlUtil.isUserDefined(tag.myTagName) || !CfmlUtil.isEndTagRequired(tag.myTagName, builder.getProject())) {
                        tag.myMarkerOfBegin.doneBefore(CfmlParser.getElementTypeForTag(tag.myTagName), tag.myMarkerOfContent);
                    } else {
                        tag.myMarkerOfBegin.doneBefore(CfmlParser.getElementTypeForTag(tag.myTagName), tag.myMarkerOfContent, CfmlBundle.message("cfml.parsing.element.is.not.closed", tag.myTagName));
                    }
                    tag.myMarkerOfContent.drop();
                }
                CfmlParser.parseCloser(builder);
                if (tag != null) {
                    tag.myMarkerOfContent.drop();
                    tag.myMarkerOfBegin.done(CfmlParser.getElementTypeForTag(tag.myTagName));
                }
                return true;
            }
            builder.error(CfmlBundle.message("cfml.parsing.closing.tag.matches.nothing", new Object[0]));
            CfmlParser.parseCloser(builder);
            return false;
        }
        return false;
    }

    private static void parseOpenTag(PsiBuilder builder, Stack<Tag> tagNamesStack) {
        while (!builder.eof()) {
            PsiBuilder.Marker marker = builder.mark();
            builder.advanceLexer();
            if (builder.getTokenType() != CfmlTokenTypes.CF_TAG_NAME) {
                builder.error(CfmlBundle.message("cfml.parsing.unexpected.token", new Object[0]));
                marker.drop();
                continue;
            }
            String currentTagName = builder.getTokenText().toLowerCase();
            builder.advanceLexer();
            CfmlParser.parseAttributes(builder, currentTagName, CfmlTokenTypes.ATTRIBUTE, false);
            if (builder.eof()) {
                builder.error(CfmlBundle.message("cfml.parsing.tag.is.not.done", new Object[0]));
                marker.done(CfmlParser.getElementTypeForTag(currentTagName));
                return;
            }
            if (builder.getTokenType() == CfmlTokenTypes.CLOSER) {
                builder.advanceLexer();
                marker.done(CfmlParser.getElementTypeForTag(currentTagName));
            } else if (builder.getTokenType() == CfmlTokenTypes.R_ANGLEBRACKET) {
                builder.advanceLexer();
                tagNamesStack.push((Object)new Tag(currentTagName, marker, builder.mark()));
            } else {
                builder.error(CfmlBundle.message("cfml.parsing.tag.is.not.done", new Object[0]));
                tagNamesStack.push((Object)new Tag(currentTagName, marker, builder.mark()));
            }
            if (currentTagName.toLowerCase().equals("cfscript")) {
                new CfscriptParser().parseScript(builder, true);
            }
            while (!builder.eof() && builder.getTokenType() != CfmlTokenTypes.OPENER) {
                if (builder.getTokenType() == CfmlTokenTypes.LSLASH_ANGLEBRACKET) {
                    CfmlParser.parseCloseTag(builder, tagNamesStack);
                    continue;
                }
                if (builder.getTokenType() == CfmlTokenTypes.START_EXPRESSION) {
                    CfmlParser.parseExpression(builder);
                    continue;
                }
                builder.advanceLexer();
            }
        }
    }

    @Nullable
    private static String swallowClosing(PsiBuilder builder) {
        if (CfmlParser.compareAndEat(builder, CfmlTokenTypes.LSLASH_ANGLEBRACKET)) {
            String tagName = builder.getTokenText();
            if (CfmlParser.compareAndEat(builder, CfmlTokenTypes.CF_TAG_NAME) && CfmlParser.compareAndEat(builder, CfmlTokenTypes.CLOSER)) {
                return tagName;
            }
        }
        return null;
    }

    private static boolean compareAndEat(PsiBuilder builder, IElementType type) {
        if (builder.getTokenType() != type) {
            return false;
        }
        builder.advanceLexer();
        return true;
    }

    public String toString() {
        return "CfmlParser";
    }

    private static class Tag {
        public String myTagName;
        public PsiBuilder.Marker myMarkerOfBegin;
        public PsiBuilder.Marker myMarkerOfContent;

        public Tag(String string, PsiBuilder.Marker marker, PsiBuilder.Marker content) {
            this.myTagName = string;
            this.myMarkerOfBegin = marker;
            this.myMarkerOfContent = content;
        }
    }
}

