/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlArgumentList;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlComponentType;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlFunction;
import com.intellij.coldFusion.model.psi.CfmlFunctionCall;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlReference;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.CfmlStringLiteralExpression;
import com.intellij.coldFusion.model.psi.CfmlTypedElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlFunctionCallExpression
extends CfmlCompositeElement
implements CfmlExpression,
CfmlFunctionCall,
CfmlTypedElement {
    public CfmlFunctionCallExpression(ASTNode node) {
        super(node);
    }

    public boolean isCreateFromJavaLoader() {
        PsiElement firstChild = this.findChildByType(CfmlElementTypes.REFERENCE_EXPRESSION);
        if (firstChild == null) {
            return false;
        }
        PsiElement lastChild = firstChild.getLastChild();
        if (lastChild == null) {
            return false;
        }
        String create = lastChild.getText();
        PsiElement secondChild = firstChild.getFirstChild();
        if (!create.toLowerCase().equals("create") || !(secondChild instanceof CfmlReferenceExpression)) {
            return false;
        }
        PsiType type = ((CfmlReferenceExpression)secondChild).getPsiType();
        if (type == null) {
            return false;
        }
        return type.getCanonicalText().toLowerCase().equals("javaloader");
    }

    @Nullable
    public PsiType getExternalType() {
        String functionName = this.getFunctionName();
        CfmlReference referenceExpression = this.getReferenceExpression();
        if ("createobject".equals(functionName.toLowerCase())) {
            CfmlArgumentList cfmlArgumentList = this.findArgumentList();
            if (cfmlArgumentList == null) {
                return null;
            }
            CfmlExpression[] argumentsList = cfmlArgumentList.getArguments();
            if (argumentsList.length == 0) {
                return null;
            }
            if (argumentsList[0] instanceof CfmlStringLiteralExpression) {
                CfmlComponentReference componentRef;
                PsiReference[] references;
                String secondParameterName = ((CfmlStringLiteralExpression)argumentsList[0]).getValue().toLowerCase();
                if ("java".equals(secondParameterName) && argumentsList.length >= 2) {
                    String className = argumentsList[1].getText();
                    className = className.substring(1, className.length() - 1);
                    PsiJavaCodeReferenceElement reference = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createReferenceElementByFQClassName(className, this.getResolveScope());
                    return new PsiClassStaticType(reference, className);
                }
                if (("component".equals(secondParameterName) && argumentsList.length >= 2 || argumentsList.length == 1) && (references = argumentsList[argumentsList.length == 1 ? 0 : 1].getReferences()).length != 0 && references[0] instanceof CfmlComponentReference && (componentRef = (CfmlComponentReference)references[0]) != null) {
                    return new CfmlComponentType(componentRef.getText(), this.getContainingFile(), this.getProject());
                }
            }
        } else if ("init".equals(this.getFunctionShortName().toLowerCase())) {
            CfmlReference qualifier = CfmlPsiUtil.getQualifierInner(this);
            CfmlReference sourceObject = CfmlPsiUtil.getQualifierInner(qualifier);
            if (sourceObject != null) {
                PsiType type = sourceObject.getPsiType();
                if (type instanceof PsiClassStaticType) {
                    return ((PsiClassStaticType)type).getRawType();
                }
                if (type instanceof CfmlComponentType) {
                    return type;
                }
            }
        } else {
            if (this.isCreateFromJavaLoader()) {
                CfmlArgumentList argumentList = this.findArgumentList();
                if (argumentList == null) {
                    return null;
                }
                CfmlExpression[] argumentsList = argumentList.getArguments();
                if (argumentsList.length == 0) {
                    return null;
                }
                String className = argumentsList[0].getText();
                className = className.substring(1, className.length() - 1);
                return CfmlPsiUtil.getTypeByName(className, this.getProject());
            }
            if (referenceExpression != null) {
                PsiElement resolve = referenceExpression.resolve();
                return resolve instanceof CfmlFunction ? ((CfmlFunction)resolve).getReturnType() : null;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType getPsiType() {
        PsiType externalType = this.getExternalType();
        if (externalType == null) {
            CfmlReference referenceExpression = this.getReferenceExpression();
            return referenceExpression != null ? referenceExpression.getPsiType() : null;
        }
        return externalType;
    }

    @NotNull
    public CfmlExpression[] getArguments() {
        CfmlArgumentList argumentListEl = (CfmlArgumentList)this.findChildByClass(CfmlArgumentList.class);
        if (argumentListEl == null) {
            CfmlExpression[] cfmlExpressionArray = new CfmlExpression[]{};
            if (cfmlExpressionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlFunctionCallExpression", "getArguments"));
            }
            return cfmlExpressionArray;
        }
        CfmlExpression[] cfmlExpressionArray = argumentListEl.getArguments();
        if (cfmlExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlFunctionCallExpression", "getArguments"));
        }
        return cfmlExpressionArray;
    }

    @NotNull
    public String[] getArgumentsAsStrings() {
        CfmlArgumentList argumentListEl = (CfmlArgumentList)this.findChildByClass(CfmlArgumentList.class);
        if (argumentListEl == null) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlFunctionCallExpression", "getArgumentsAsStrings"));
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        Object[] args = argumentListEl.getArguments();
        String[] stringArray = (String[])ContainerUtil.map((Object[])args, cfmlExpression -> {
            if (cfmlExpression instanceof CfmlStringLiteralExpression) {
                return ((CfmlStringLiteralExpression)cfmlExpression).getValue().toLowerCase();
            }
            return "";
        }, (Object[])ArrayUtil.EMPTY_STRING_ARRAY);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlFunctionCallExpression", "getArgumentsAsStrings"));
        }
        return stringArray;
    }

    public String getFunctionShortName() {
        CfmlReference referenceExpression = this.getReferenceExpression();
        if (referenceExpression == null) {
            return "";
        }
        PsiElement child = referenceExpression.getLastChild();
        return child != null ? child.getText() : "";
    }

    public String getFunctionName() {
        String functionName = "";
        CfmlReference referenceExpression = this.getReferenceExpression();
        if (referenceExpression != null && referenceExpression.getText() != null) {
            functionName = referenceExpression.getText();
        }
        return functionName;
    }

    public boolean isCreateObject() {
        return this.getFunctionName().toLowerCase().equals("createobject");
    }

    public boolean isExpandPath() {
        return this.getFunctionName().toLowerCase().equals("expandpath");
    }

    @Override
    @Nullable
    public CfmlReference getReferenceExpression() {
        return (CfmlReference)this.findChildByClass(CfmlReferenceExpression.class);
    }

    @Override
    @Nullable
    public CfmlArgumentList findArgumentList() {
        return (CfmlArgumentList)this.findChildByClass(CfmlArgumentList.class);
    }

    @Override
    public PsiType[] getArgumentTypes() {
        CfmlArgumentList argumentsList = this.findArgumentList();
        if (argumentsList == null) {
            return PsiType.EMPTY_ARRAY;
        }
        Object[] args = argumentsList.getArguments();
        return (PsiType[])ContainerUtil.map2Array((Object[])args, PsiType.class, (Function)((NullableFunction)expression -> expression.getPsiType()));
    }

    public class PsiClassStaticType
    extends PsiClassReferenceType {
        private String myClassName;

        public PsiClassStaticType(PsiJavaCodeReferenceElement reference, String className) {
            super(reference, null);
            this.myClassName = className;
        }

        @Nullable
        public PsiType getRawType() {
            return CfmlPsiUtil.getTypeByName(this.myClassName, CfmlFunctionCallExpression.this.getProject());
        }
    }
}

