/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class CfmlJavaLoaderClassType
extends PsiType {
    private GlobalSearchScope mySearchScope;
    private Project myProject;

    public CfmlJavaLoaderClassType(PsiComment comment, Project project) {
        super(PsiAnnotation.EMPTY_ARRAY);
        Collection<String> collection;
        String text = comment.getText();
        this.myProject = project;
        Matcher javaLoaderMatcher = CfmlFile.LOADER_DECL_PATTERN_TEMP.matcher(text);
        this.mySearchScope = GlobalSearchScope.allScope((Project)project);
        if (javaLoaderMatcher.matches() && (collection = CfmlPsiUtil.findBetween(text, "loadPaths=\"", "\"")) != null) {
            for (String str : collection) {
                VirtualFile file = JarFileSystem.getInstance().findFileByPath(str + "!/");
                if (file == null) continue;
                this.mySearchScope = this.mySearchScope.uniteWith((GlobalSearchScope)new JarFileScope(file));
            }
        }
    }

    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    @NotNull
    public String getPresentableText() {
        String string = this.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        if ("JavaLoader" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType", "getCanonicalText"));
        }
        return "JavaLoader";
    }

    public boolean isValid() {
        return true;
    }

    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType", "equalsToText"));
        }
        return false;
    }

    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType", "accept"));
        }
        return (A)visitor.visitType((PsiType)this);
    }

    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @NotNull
    public PsiType[] getSuperTypes() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType", "getSuperTypes"));
        }
        return EMPTY_ARRAY;
    }

    private class JarFileScope
    extends GlobalSearchScope {
        private final VirtualFile myVirtualFile;
        private final Module myModule;

        private JarFileScope(VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType$JarFileScope", "<init>"));
            }
            this.myVirtualFile = file;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)CfmlJavaLoaderClassType.this.myProject).getFileIndex();
            this.myModule = fileIndex.getModuleForFile(this.myVirtualFile);
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType$JarFileScope", "contains"));
            }
            return VfsUtilCore.isAncestor((VirtualFile)this.myVirtualFile, (VirtualFile)file, (boolean)true);
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType$JarFileScope", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType$JarFileScope", "compare"));
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/coldFusion/model/psi/CfmlJavaLoaderClassType$JarFileScope", "isSearchInModuleContent"));
            }
            return aModule == this.myModule;
        }

        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }
    }
}

