/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi.impl;

import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.coldFusion.model.psi.CfmlScopeProvider;
import com.intellij.coldFusion.model.psi.impl.CfmlAttributeImpl;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CfmlAttributeNameImpl
extends CfmlAttributeImpl {
    public CfmlAttributeNameImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public String getAttributeName() {
        return "name";
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement element = this.findChildByType(CfmlElementTypes.ATTRIBUTE_VALUE);
        Object object = element != null ? element : this;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlAttributeNameImpl", "getNavigationElement"));
        }
        return object;
    }

    @Override
    public int getProvidedScope() {
        PsiElement parent = this.getParent();
        if (parent instanceof CfmlScopeProvider) {
            return ((CfmlScopeProvider)parent).getProvidedScope();
        }
        return super.getProvidedScope();
    }

    public int getTextOffset() {
        PsiElement element = this.getNavigationElement();
        return element.getTextRange().getStartOffset();
    }

    public PsiElement getNameIdentifier() {
        return this.getNavigationElement();
    }

    public PsiElement setName(@NotNull @NonNls String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/coldFusion/model/psi/impl/CfmlAttributeNameImpl", "setName"));
        }
        CheckUtil.checkWritable((PsiElement)this);
        PsiElement newElement = CfmlPsiUtil.createConstantString(name, this.getProject());
        this.getNode().replaceChild(this.getValueElement().getNode(), newElement.getNode());
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        String name = this.getPureAttributeValue();
        String string = name != null ? name : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/impl/CfmlAttributeNameImpl", "getName"));
        }
        return string;
    }
}

