/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.gapi;

import com.android.tools.idea.editors.gfxtrace.gapi.GapisFeatures;
import com.android.tools.idea.editors.gfxtrace.gapi.GapisProcess;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientRPC;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class GapisConnection
implements Closeable {
    @NotNull
    private static final byte[] AUTH_HEADER = new byte[]{65, 85, 84, 72};
    private final GapisProcess myParent;
    private final Socket myServerSocket;
    private final GapisFeatures myFeatures = new GapisFeatures();

    public GapisConnection(GapisProcess parent, Socket serverSocket) {
        this.myParent = parent;
        this.myServerSocket = serverSocket;
    }

    public boolean isConnected() {
        return this.myServerSocket != null && this.myServerSocket.isConnected();
    }

    public GapisFeatures getFeatures() {
        return this.myFeatures;
    }

    public ServiceClient createServiceClient(ListeningExecutorService executor) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Not connected");
        }
        return new ServiceClientRPC(executor, this.myServerSocket.getInputStream(), this.myServerSocket.getOutputStream(), 1024, this.myParent.getVersion().major);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GapisConnection gapisConnection = this;
        synchronized (gapisConnection) {
            if (this.isConnected()) {
                try {
                    this.myServerSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.myParent.onClose(this);
            }
        }
    }

    public void sendAuth(String authToken) throws IOException {
        OutputStream s = this.myServerSocket.getOutputStream();
        s.write(AUTH_HEADER);
        s.write(authToken.getBytes("UTF-8"));
        s.write(new byte[]{0});
    }
}

