/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.android.tools.idea.editors.gfxtrace.widgets.Tree;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyEnabledTree
extends Tree
implements DataProvider,
CopyProvider {
    private final ColumnTextProvider myColumnTextProvider;

    public CopyEnabledTree(TreeModel model, @NotNull ColumnTextProvider columnTextProvider) {
        if (columnTextProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnTextProvider", "com/android/tools/idea/editors/gfxtrace/widgets/CopyEnabledTree", "<init>"));
        }
        super(model);
        this.myColumnTextProvider = columnTextProvider;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/editors/gfxtrace/widgets/CopyEnabledTree", "isCopyEnabled"));
        }
        TreePath[] paths = this.getSelectionPaths();
        return paths != null && paths.length > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/editors/gfxtrace/widgets/CopyEnabledTree", "isCopyVisible"));
        }
        return true;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/editors/gfxtrace/widgets/CopyEnabledTree", "performCopy"));
        }
        if (this.isCopyEnabled(dataContext)) {
            CopyPasteManager.getInstance().setContents(this.createTransferable());
        }
    }

    private Transferable createTransferable() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        ArrayList<Node> roots = new ArrayList<Node>(paths.length);
        HashMap<TreePath, Node> pathToNode = new HashMap<TreePath, Node>(paths.length);
        for (TreePath path : paths) {
            this.createNode(path, pathToNode, roots);
        }
        ArrayList<Integer> maxColumnWidths = new ArrayList<Integer>(2);
        for (Node node : roots) {
            node.sort();
            node.measure(maxColumnWidths, 0);
        }
        StringBuffer plainBuf = new StringBuffer();
        for (Node node : roots) {
            node.print(plainBuf, maxColumnWidths);
        }
        return new TextTransferable(null, plainBuf.toString());
    }

    private Node createNode(TreePath path, Map<TreePath, Node> pathToNode, List<Node> roots) {
        Node node = pathToNode.getOrDefault(path, null);
        if (node != null) {
            return node;
        }
        int order = this.getRowForPath(path);
        node = new Node(this.myColumnTextProvider.getColumns(path), order);
        pathToNode.put(path, node);
        TreePath parent = path.getParentPath();
        if (parent != null) {
            this.createNode(parent, pathToNode, roots).myChildren.add(node);
        } else {
            roots.add(node);
        }
        return node;
    }

    private static class Node
    implements Comparable<Node> {
        private final int myOrder;
        private final List<Node> myChildren;
        private final String[] myColumns;
        private static final int INDENT_SIZE = 4;
        private static final String INDENT = "\u2502   ";
        private static final String INDENT_LAST = "    ";
        private static final String BRANCH = "\u251c\u2500\u2500 ";
        private static final String BRANCH_LAST = "\u2514\u2500\u2500 ";

        public Node(String[] columns, int order) {
            this.myColumns = columns;
            this.myOrder = order;
            this.myChildren = new ArrayList<Node>();
        }

        public void sort() {
            Collections.sort(this.myChildren);
            for (Node child : this.myChildren) {
                child.sort();
            }
        }

        public void measure(@NotNull List<Integer> maxColumnWidths, int indent) {
            if (maxColumnWidths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxColumnWidths", "com/android/tools/idea/editors/gfxtrace/widgets/CopyEnabledTree$Node", "measure"));
            }
            while (maxColumnWidths.size() < this.myColumns.length) {
                maxColumnWidths.add(0);
            }
            int c = this.myColumns.length;
            for (int i = 0; i < c; ++i) {
                int width = this.myColumns[i].length();
                if (i == 0) {
                    width += indent;
                }
                if (i < c - 1) {
                    ++width;
                }
                maxColumnWidths.set(i, Math.max(width, maxColumnWidths.get(i)));
            }
            for (Node child : this.myChildren) {
                child.measure(maxColumnWidths, indent + 4);
            }
        }

        public void print(StringBuffer sb, List<Integer> maxColumnWidths) {
            this.print(sb, maxColumnWidths, "", true, false);
        }

        public void print(StringBuffer sb, List<Integer> maxColumnWidths, String prefix, boolean root, boolean last) {
            StringBuffer column = new StringBuffer();
            if (!root) {
                column.append(prefix);
                column.append(last ? BRANCH_LAST : BRANCH);
                prefix = prefix + (last ? INDENT_LAST : INDENT);
            }
            int c = this.myColumns.length;
            for (int i = 0; i < c; ++i) {
                column.append(this.myColumns[i]);
                if (i < c - 1) {
                    while (column.length() < maxColumnWidths.get(i)) {
                        column.append(' ');
                    }
                }
                sb.append(column.toString());
                column.setLength(0);
            }
            sb.append("\n");
            int childCount = this.myChildren.size();
            for (int i = 0; i < childCount; ++i) {
                this.myChildren.get(i).print(sb, maxColumnWidths, prefix, false, i == childCount - 1);
            }
        }

        @Override
        public int compareTo(Node o) {
            return this.myOrder - o.myOrder;
        }
    }

    public static interface ColumnTextProvider {
        @NotNull
        public String[] getColumns(TreePath var1);
    }
}

