/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.customizer.java;

import com.android.tools.idea.gradle.JavaProject;
import com.android.tools.idea.gradle.customizer.AbstractDependenciesModuleCustomizer;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactsByConfigurationModuleCustomizer
implements ModuleCustomizer<JavaProject> {
    @Override
    public void customizeModule(@NotNull Project project, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider, @Nullable JavaProject javaProject) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/customizer/java/ArtifactsByConfigurationModuleCustomizer", "customizeModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/customizer/java/ArtifactsByConfigurationModuleCustomizer", "customizeModule"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/android/tools/idea/gradle/customizer/java/ArtifactsByConfigurationModuleCustomizer", "customizeModule"));
        }
        if (javaProject != null) {
            ModifiableRootModel moduleModel = modelsProvider.getModifiableRootModel(module);
            for (Map.Entry<String, Set<File>> entry : javaProject.getArtifactsByConfiguration().entrySet()) {
                Set<File> artifacts = entry.getValue();
                if (artifacts == null || artifacts.isEmpty()) continue;
                for (File artifact : artifacts) {
                    String libraryName;
                    Library library;
                    if (!artifact.isFile() || !StringUtil.endsWithIgnoreCase((String)artifact.getName(), (String)".jar")) continue;
                    File buildFolderPath = javaProject.getBuildFolderPath();
                    String artifactName = FileUtil.getNameWithoutExtension((File)artifact);
                    if (buildFolderPath != null && buildFolderPath.isDirectory() && FileUtil.isAncestor((File)buildFolderPath, (File)artifact, (boolean)true) && module.getName().equals(artifactName) || (library = modelsProvider.getLibraryByName(libraryName = module.getName() + "." + artifactName)) != null) continue;
                    library = modelsProvider.createLibrary(libraryName);
                    Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
                    String url = AbstractDependenciesModuleCustomizer.pathToUrl(artifact.getPath());
                    libraryModel.addRoot(url, OrderRootType.CLASSES);
                    LibraryOrderEntry orderEntry = moduleModel.addLibraryEntry(library);
                    orderEntry.setScope(DependencyScope.COMPILE);
                    orderEntry.setExported(true);
                }
            }
        }
    }
}

