/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview;

import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.DependencyNodeComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDependencyNode
extends AbstractDependencyNode<PsLibraryAndroidDependency> {
    @NotNull
    private final List<AbstractDependencyNode> myChildren;

    public LibraryDependencyNode(@NotNull AbstractPsNode parent, @NotNull PsLibraryAndroidDependency dependency) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "<init>"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "<init>"));
        }
        super(parent, dependency);
        this.myChildren = Lists.newArrayList();
        this.setUp(dependency);
    }

    public LibraryDependencyNode(@NotNull AbstractPsNode parent, @NotNull List<PsLibraryAndroidDependency> dependencies) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "<init>"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "<init>"));
        }
        super(parent, dependencies);
        this.myChildren = Lists.newArrayList();
        assert (!dependencies.isEmpty());
        this.setUp(dependencies.get(0));
    }

    private void setUp(@NotNull PsLibraryAndroidDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "setUp"));
        }
        this.myName = this.getText(dependency);
        ImmutableCollection<PsDependency> transitiveDependencies = dependency.getTransitiveDependencies();
        transitiveDependencies.stream().filter(transitive -> transitive instanceof PsLibraryAndroidDependency).forEach(transitive -> {
            PsLibraryAndroidDependency transitiveLibrary = (PsLibraryAndroidDependency)transitive;
            LibraryDependencyNode child = new LibraryDependencyNode((AbstractPsNode)this, transitiveLibrary);
            this.myChildren.add(child);
        });
        Collections.sort(this.myChildren, DependencyNodeComparator.INSTANCE);
    }

    @NotNull
    private String getText(@NotNull PsLibraryAndroidDependency dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "getText"));
        }
        PsArtifactDependencySpec resolvedSpec = dependency.getResolvedSpec();
        if (dependency.hasPromotedVersion() && !(this.getParent() instanceof LibraryDependencyNode)) {
            PsArtifactDependencySpec declaredSpec = dependency.getDeclaredSpec();
            assert (declaredSpec != null);
            String version = declaredSpec.version + "\u2192" + resolvedSpec.version;
            String string = LibraryDependencyNode.getTextForSpec(declaredSpec.name, version, declaredSpec.group);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "getText"));
            }
            return string;
        }
        String string = resolvedSpec.getDisplayText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "getText"));
        }
        return string;
    }

    @NotNull
    private static String getTextForSpec(@NotNull String name, @NotNull String version, @Nullable String group) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "getTextForSpec"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "getTextForSpec"));
        }
        boolean showGroupId = PsUISettings.getInstance().DECLARED_DEPENDENCIES_SHOW_GROUP_ID;
        StringBuilder text = new StringBuilder();
        if (showGroupId && StringUtil.isNotEmpty((String)group)) {
            text.append(group).append(":");
        }
        text.append(name).append(":").append(version);
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "getTextForSpec"));
        }
        return string;
    }

    public SimpleNode[] getChildren() {
        return this.myChildren.toArray(new SimpleNode[this.myChildren.size()]);
    }

    @Override
    public boolean matches(@NotNull PsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode", "matches"));
        }
        if (model instanceof PsLibraryAndroidDependency) {
            PsLibraryAndroidDependency other = (PsLibraryAndroidDependency)model;
            List models = this.getModels();
            for (PsLibraryAndroidDependency dependency : models) {
                if (!dependency.getResolvedSpec().equals(other.getResolvedSpec())) continue;
                return true;
            }
        }
        return false;
    }
}

