/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsDependency
extends PsChildModel
implements PsBaseDependency {
    @NotNull
    private final Set<DependencyModel> myParsedModels;

    protected PsDependency(@NotNull PsModule parent, @Nullable DependencyModel parsedModel) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/model/PsDependency", "<init>"));
        }
        super(parent);
        this.myParsedModels = Sets.newHashSet();
        if (parsedModel != null) {
            this.myParsedModels.add(parsedModel);
        }
    }

    @Override
    @NotNull
    public String getJoinedConfigurationNames() {
        List<String> configurationNames = this.getConfigurationNames();
        int count = configurationNames.size();
        if (count == 1) {
            String string = configurationNames.get(0);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsDependency", "getJoinedConfigurationNames"));
            }
            return string;
        }
        if (count > 1) {
            String string = Joiner.on((String)", ").join(configurationNames);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsDependency", "getJoinedConfigurationNames"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsDependency", "getJoinedConfigurationNames"));
        }
        return "";
    }

    @NotNull
    public List<String> getConfigurationNames() {
        if (this.myParsedModels.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsDependency", "getConfigurationNames"));
            }
            return list;
        }
        ArrayList names = Lists.newArrayList((Iterable)this.myParsedModels.stream().map(DependencyModel::configurationName).collect(Collectors.toSet()));
        Collections.sort(names);
        ArrayList arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsDependency", "getConfigurationNames"));
        }
        return arrayList;
    }

    @Override
    public boolean isDeclared() {
        return !this.myParsedModels.isEmpty();
    }

    public void addParsedModel(@NotNull DependencyModel parsedModel) {
        if (parsedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsedModel", "com/android/tools/idea/gradle/structure/model/PsDependency", "addParsedModel"));
        }
        this.myParsedModels.add(parsedModel);
    }

    @NotNull
    public ImmutableCollection<DependencyModel> getParsedModels() {
        ImmutableSet immutableSet = this.myParsedModels.isEmpty() ? ImmutableSet.of() : ImmutableSet.copyOf(this.myParsedModels);
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsDependency", "getParsedModels"));
        }
        return immutableSet;
    }

    public static enum TextType {
        PLAIN_TEXT,
        FOR_NAVIGATION;

    }
}

