/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model;

import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.base.Objects;
import com.intellij.icons.AllIcons;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsIssue {
    @NotNull
    private final String myText;
    @NotNull
    private final PsPath myPath;
    @NotNull
    private final PsIssueType myType;
    @NotNull
    private final Severity mySeverity;
    @Nullable
    private final String myDescription;
    @Nullable
    private PsPath myExtraPath;
    @Nullable
    private PsPath myQuickFixPath;

    public PsIssue(@NotNull String text, @NotNull PsPath path, @NotNull PsIssueType type, @NotNull Severity severity) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/structure/model/PsIssue", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/structure/model/PsIssue", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/structure/model/PsIssue", "<init>"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/android/tools/idea/gradle/structure/model/PsIssue", "<init>"));
        }
        this.myText = text;
        this.myPath = path;
        this.myType = type;
        this.mySeverity = severity;
        this.myDescription = null;
    }

    public PsIssue(@NotNull String text, @NotNull String description, @NotNull PsPath path, @NotNull PsIssueType type, @NotNull Severity severity) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/structure/model/PsIssue", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/gradle/structure/model/PsIssue", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/structure/model/PsIssue", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/structure/model/PsIssue", "<init>"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/android/tools/idea/gradle/structure/model/PsIssue", "<init>"));
        }
        this.myText = text;
        this.myDescription = description;
        this.myPath = path;
        this.myType = type;
        this.mySeverity = severity;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsIssue", "getText"));
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public Severity getSeverity() {
        Severity severity = this.mySeverity;
        if (severity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsIssue", "getSeverity"));
        }
        return severity;
    }

    @NotNull
    public PsPath getPath() {
        PsPath psPath = this.myPath;
        if (psPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsIssue", "getPath"));
        }
        return psPath;
    }

    @Nullable
    public PsPath getExtraPath() {
        return this.myExtraPath;
    }

    public void setExtraPath(@Nullable PsPath extraPath) {
        this.myExtraPath = extraPath;
    }

    @Nullable
    public PsPath getQuickFixPath() {
        return this.myQuickFixPath;
    }

    public void setQuickFixPath(@Nullable PsPath quickFixPath) {
        this.myQuickFixPath = quickFixPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsIssue that = (PsIssue)o;
        return Objects.equal((Object)this.myText, (Object)that.myText) && Objects.equal((Object)this.myDescription, (Object)that.myDescription) && Objects.equal((Object)this.myPath, (Object)that.getPath()) && this.mySeverity == that.mySeverity;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myText, this.myDescription, this.myPath, this.mySeverity});
    }

    public String toString() {
        return this.mySeverity.name() + ": " + this.myText;
    }

    @NotNull
    public PsIssueType getType() {
        PsIssueType psIssueType = this.myType;
        if (psIssueType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsIssue", "getType"));
        }
        return psIssueType;
    }

    public static enum Severity {
        ERROR("Error", AllIcons.General.BalloonError, (Color)JBColor.RED, 0),
        WARNING("Warning", AllIcons.General.BalloonWarning, (Color)JBColor.YELLOW, 1),
        INFO("Information", AllIcons.General.BalloonInformation, (Color)JBColor.GRAY, 2),
        UPDATE("Update", AllIcons.Actions.Download, (Color)JBColor.GRAY, 3);

        @NotNull
        private final Icon myIcon;
        @NotNull
        private final String myText;
        @NotNull
        private final Color myColor;
        private final int myPriority;

        private Severity(@NotNull String text, Icon icon, Color color, int priority) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/structure/model/PsIssue$Severity", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/gradle/structure/model/PsIssue$Severity", "<init>"));
            }
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/android/tools/idea/gradle/structure/model/PsIssue$Severity", "<init>"));
            }
            this.myText = text;
            this.myColor = color;
            this.myIcon = icon;
            this.myPriority = priority;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsIssue$Severity", "getText"));
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsIssue$Severity", "getIcon"));
            }
            return icon;
        }

        @NotNull
        public Color getColor() {
            Color color = this.myColor;
            if (color == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/PsIssue$Severity", "getColor"));
            }
            return color;
        }

        public int getPriority() {
            return this.myPriority;
        }
    }
}

