/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModel;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsDependencyContainer;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsAndroidDependency
extends PsDependency
implements PsAndroidModel {
    @NotNull
    private final Set<PsDependencyContainer> myContainers;

    PsAndroidDependency(@NotNull PsAndroidModule parent, @NotNull PsAndroidArtifact container, @Nullable DependencyModel parsedModel) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependency", "<init>"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependency", "<init>"));
        }
        super(parent, parsedModel);
        this.myContainers = Sets.newHashSet();
        this.addContainer(container);
    }

    @Override
    @NotNull
    public AndroidGradleModel getGradleModel() {
        AndroidGradleModel androidGradleModel = this.getParent().getGradleModel();
        if (androidGradleModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependency", "getGradleModel"));
        }
        return androidGradleModel;
    }

    @Override
    @NotNull
    public PsAndroidModule getParent() {
        PsAndroidModule psAndroidModule = (PsAndroidModule)super.getParent();
        if (psAndroidModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependency", "getParent"));
        }
        return psAndroidModule;
    }

    void addContainer(@NotNull PsAndroidArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependency", "addContainer"));
        }
        this.myContainers.add(new PsDependencyContainer(artifact));
    }

    @NotNull
    public Collection<String> getVariants() {
        Collection collection = this.myContainers.stream().map(PsDependencyContainer::getVariant).collect(Collectors.toSet());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependency", "getVariants"));
        }
        return collection;
    }

    @NotNull
    public Collection<PsDependencyContainer> getContainers() {
        Set<PsDependencyContainer> set = this.myContainers;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependency", "getContainers"));
        }
        return set;
    }

    public boolean isIn(@NotNull String artifactName, @Nullable String variantName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/gradle/structure/model/android/PsAndroidDependency", "isIn"));
        }
        for (PsDependencyContainer container : this.myContainers) {
            if (!artifactName.equals(container.getArtifact())) continue;
            if (variantName == null) {
                return true;
            }
            if (!variantName.equals(container.getVariant())) continue;
            return true;
        }
        return false;
    }
}

