/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.pom;

import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenPoms {
    private static final Logger LOG = Logger.getInstance(MavenPoms.class);

    private MavenPoms() {
    }

    @NotNull
    public static List<PsArtifactDependencySpec> findDependenciesInPomFile(@NotNull File libraryPath) {
        if (libraryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryPath", "com/android/tools/idea/gradle/structure/model/pom/MavenPoms", "findDependenciesInPomFile"));
        }
        VirtualFile pomFile = GradleUtil.findPomForLibrary(libraryPath);
        if (pomFile == null) {
            List<PsArtifactDependencySpec> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/pom/MavenPoms", "findDependenciesInPomFile"));
            }
            return list;
        }
        ArrayList dependencies = Lists.newArrayList();
        try {
            Document document = JDOMUtil.loadDocument((File)VfsUtilCore.virtualToIoFile((VirtualFile)pomFile));
            Element rootElement = document.getRootElement();
            if (rootElement != null) {
                Element dependenciesElement = null;
                for (Element childElement : rootElement.getChildren()) {
                    if (!"dependencies".equals(childElement.getName())) continue;
                    dependenciesElement = childElement;
                    break;
                }
                if (dependenciesElement != null) {
                    for (Element childElement : dependenciesElement.getChildren()) {
                        PsArtifactDependencySpec spec;
                        if (!"dependency".equals(childElement.getName()) || (spec = MavenPoms.createSpec(childElement)) == null) continue;
                        dependencies.add(spec);
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = String.format("Failed to obtain dependencies in POM file for library '%1$s", libraryPath.getName());
            LOG.warn(msg, (Throwable)e);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/pom/MavenPoms", "findDependenciesInPomFile"));
        }
        return arrayList;
    }

    @Nullable
    private static PsArtifactDependencySpec createSpec(@NotNull Element dependencyElement) {
        if (dependencyElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyElement", "com/android/tools/idea/gradle/structure/model/pom/MavenPoms", "createSpec"));
        }
        String artifactId = null;
        String groupId = null;
        String version = null;
        String scope = null;
        boolean optional = false;
        for (Element childElement : dependencyElement.getChildren()) {
            String name = childElement.getName();
            if ("artifactId".equals(name)) {
                artifactId = MavenPoms.textOf(childElement);
                continue;
            }
            if ("groupId".equals(name)) {
                groupId = MavenPoms.textOf(childElement);
                continue;
            }
            if ("version".equals(name)) {
                version = MavenPoms.textOf(childElement);
                continue;
            }
            if ("optional".equals(name)) {
                optional = Boolean.valueOf(MavenPoms.textOf(childElement));
                continue;
            }
            if (!"scope".equals(name)) continue;
            scope = MavenPoms.textOf(childElement);
        }
        if (StringUtil.isNotEmpty(artifactId) && !optional && ("compile".equals(scope) || StringUtil.isEmpty(scope))) {
            return new PsArtifactDependencySpec(artifactId, groupId, version);
        }
        return null;
    }

    @Nullable
    private static String textOf(@NotNull Element e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/model/pom/MavenPoms", "textOf"));
        }
        return StringUtil.nullize((String)e.getText(), (boolean)true);
    }
}

