/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.EventData;
import com.android.tools.adtui.TimelineComponent;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.monitor.DeviceSampler;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Key;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMonitorView<T extends DeviceSampler>
implements HierarchyListener,
TimelineEventListener,
DeviceContext.DeviceSelectionListener {
    public static final Key<BaseMonitorView> MONITOR_VIEW_KEY = Key.create((String)"MONITOR_VIEW_KEY");
    @NotNull
    private static final String PAUSED_LABEL = "This monitor is disabled.";
    @NotNull
    private static final String PAUSED_KEY = ".paused";
    @NotNull
    private static final String POSITION_KEY = ".position";
    @NotNull
    private static final String MINIMIZED_KEY = ".minimized";
    @NotNull
    private static final Integer OVERLAY_LAYER = JLayeredPane.DEFAULT_LAYER + 10;
    @NotNull
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    protected static final int PAUSED_LABEL_PRIORITY = 5;
    @NotNull
    protected Project myProject;
    @NotNull
    protected DeviceContext myDeviceContext;
    @NotNull
    protected JLayeredPane myContentPane;
    @NotNull
    protected volatile TimelineComponent myTimelineComponent;
    @NotNull
    protected final T mySampler;
    @NotNull
    protected final EventData myEvents;
    @NotNull
    private JPanel myTextPanel;
    @NotNull
    private JTextPane myOverlayText;
    @NotNull
    private HashMap<String, ZOrderedOverlayText> myOverlayLookup;
    @NotNull
    private PriorityQueue<ZOrderedOverlayText> myVisibleOverlays;
    private int myPosition;
    private boolean myIsMinimized;

    protected BaseMonitorView(@NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull T sampler, float bufferTime, float initialMax, float absoluteMax, float initialMarkerSeparation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/monitor/BaseMonitorView", "<init>"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "com/android/tools/idea/monitor/BaseMonitorView", "<init>"));
        }
        if (sampler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sampler", "com/android/tools/idea/monitor/BaseMonitorView", "<init>"));
        }
        this.myEvents = new EventData();
        this.myProject = project;
        this.myDeviceContext = deviceContext;
        this.myDeviceContext.addListener(this, (Disposable)project);
        this.mySampler = sampler;
        ((DeviceSampler)this.mySampler).addListener(this);
        this.myTimelineComponent = new TimelineComponent(((DeviceSampler)this.mySampler).getTimelineData(), this.myEvents, bufferTime, initialMax, absoluteMax, initialMarkerSeparation);
        Choreographer.animate((AnimatedComponent)this.myTimelineComponent);
        this.myContentPane = new JBLayeredPane(){

            public void doLayout() {
                Component[] components = this.getComponents();
                Rectangle r = this.getBounds();
                for (Component c : components) {
                    c.setBounds(0, 0, r.width, r.height);
                }
            }

            public Dimension getPreferredSize() {
                return this.getBounds().getSize();
            }
        };
        this.myTextPanel = new JPanel(new GridBagLayout()){
            Color translucentBackgroundColor;
            {
                this.translucentBackgroundColor = ColorUtil.toAlpha((Color)BACKGROUND_COLOR, (int)192);
            }

            @Override
            public void paintComponent(@NotNull Graphics g) {
                if (g == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/android/tools/idea/monitor/BaseMonitorView$2", "paintComponent"));
                }
                g.setColor(this.translucentBackgroundColor);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        this.myTextPanel.setOpaque(false);
        this.myOverlayText = new JTextPane();
        this.myOverlayText.setEditable(false);
        this.myOverlayText.setOpaque(false);
        this.myOverlayText.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myOverlayText.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myOverlayText.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.myOverlayLookup = new HashMap();
        this.myVisibleOverlays = new PriorityQueue<ZOrderedOverlayText>(5, new Comparator<ZOrderedOverlayText>(){

            @Override
            public int compare(ZOrderedOverlayText a, ZOrderedOverlayText b) {
                return a.myZ - b.myZ;
            }
        });
        this.myTextPanel.add(this.myOverlayText);
        this.myTextPanel.setVisible(false);
        this.myContentPane.add(this.myTextPanel, OVERLAY_LAYER, 0);
        this.myContentPane.addHierarchyListener(this);
        this.addOverlayText(PAUSED_LABEL, 5);
        this.performPausing(this.getPausedSetting());
        this.myPosition = this.getPositionSetting();
        this.myIsMinimized = this.getIsMinimizedSetting();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && !((DeviceSampler)this.mySampler).isRunning()) {
            ((DeviceSampler)this.mySampler).start();
        }
    }

    @NotNull
    public ComponentWithActions createComponent() {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this.myContentPane, "Center");
        ComponentWithActions.Impl impl = new ComponentWithActions.Impl(this.getToolbarActions(), null, null, null, (JComponent)wrapper);
        if (impl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/BaseMonitorView", "createComponent"));
        }
        return impl;
    }

    public abstract ActionGroup getToolbarActions();

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/BaseMonitorView", "getProject"));
        }
        return project;
    }

    @NotNull
    public DeviceContext getDeviceContext() {
        DeviceContext deviceContext = this.myDeviceContext;
        if (deviceContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/BaseMonitorView", "getDeviceContext"));
        }
        return deviceContext;
    }

    @NotNull
    public EventData getEvents() {
        EventData eventData = this.myEvents;
        if (eventData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/BaseMonitorView", "getEvents"));
        }
        return eventData;
    }

    @Override
    public void clientSelected(@Nullable Client c) {
        ((DeviceSampler)this.mySampler).setClient(c);
    }

    @Override
    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/monitor/BaseMonitorView", "deviceChanged"));
        }
    }

    @Override
    public void deviceSelected(@Nullable IDevice device) {
    }

    public void setIsPaused(boolean isPaused) {
        this.performPausing(isPaused);
        this.setProperty(PAUSED_KEY, Boolean.toString(isPaused), Boolean.toString(this.getPreferredPausedState()));
    }

    public boolean getIsPaused() {
        return ((DeviceSampler)this.mySampler).getIsPaused();
    }

    public void setIsMinimized(boolean minimized) {
        this.setProperty(MINIMIZED_KEY, Boolean.toString(minimized), Boolean.toString(false));
        this.myIsMinimized = minimized;
    }

    public boolean getIsMinimized() {
        return this.myIsMinimized;
    }

    public void setPosition(int position) {
        this.setProperty(POSITION_KEY, Integer.toString(position), Integer.toString(this.getDefaultPosition()));
        this.myPosition = position;
    }

    public int getPosition() {
        return this.myPosition;
    }

    @Override
    public void onStart() {
        EdtExecutor.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                BaseMonitorView.this.setOverlayEnabled(BaseMonitorView.PAUSED_LABEL, false);
            }
        });
    }

    @Override
    public void onStop() {
        EdtExecutor.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                BaseMonitorView.this.setOverlayEnabled(BaseMonitorView.PAUSED_LABEL, true);
            }
        });
    }

    @NotNull
    public abstract String getTitleName();

    @NotNull
    public abstract Icon getTitleIcon();

    @NotNull
    public abstract String getMonitorName();

    @NotNull
    public abstract String getDescription();

    @NotNull
    public Color getViewBackgroundColor() {
        Color color = this.myTimelineComponent.getBackground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/monitor/BaseMonitorView", "getViewBackgroundColor"));
        }
        return color;
    }

    protected final void addOverlayText(@NotNull String text, int index) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/monitor/BaseMonitorView", "addOverlayText"));
        }
        assert (!this.myOverlayLookup.containsKey(text) && index >= 0 && index < Integer.MAX_VALUE);
        this.myOverlayLookup.put(text, new ZOrderedOverlayText(text, index));
    }

    protected final void setOverlayEnabled(@NotNull String text, boolean enabled) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/monitor/BaseMonitorView", "setOverlayEnabled"));
        }
        assert (this.myOverlayLookup.containsKey(text));
        ZOrderedOverlayText orderedText = this.myOverlayLookup.get(text);
        if (enabled) {
            if (!this.myVisibleOverlays.contains(orderedText)) {
                this.myVisibleOverlays.add(orderedText);
                this.updateOverlayText(this.myVisibleOverlays.peek().myText);
            }
        } else {
            this.myVisibleOverlays.remove(orderedText);
            if (this.myVisibleOverlays.size() > 0) {
                this.updateOverlayText(this.myVisibleOverlays.peek().myText);
            } else {
                this.updateOverlayText("");
            }
        }
    }

    protected final void setViewComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/monitor/BaseMonitorView", "setViewComponent"));
        }
        this.myContentPane.add(component, JLayeredPane.DEFAULT_LAYER, 0);
    }

    protected boolean getPreferredPausedState() {
        return false;
    }

    protected abstract int getDefaultPosition();

    private boolean getPausedSetting() {
        return this.getBooleanProperty(PAUSED_KEY, this.getPreferredPausedState());
    }

    private int getPositionSetting() {
        return this.getIntProperty(POSITION_KEY, this.getDefaultPosition());
    }

    private boolean getIsMinimizedSetting() {
        return this.getBooleanProperty(MINIMIZED_KEY, false);
    }

    private void setProperty(@NotNull String propertyId, @NotNull String propertyValue, @NotNull String defaultValue) {
        if (propertyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyId", "com/android/tools/idea/monitor/BaseMonitorView", "setProperty"));
        }
        if (propertyValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyValue", "com/android/tools/idea/monitor/BaseMonitorView", "setProperty"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/android/tools/idea/monitor/BaseMonitorView", "setProperty"));
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(this.getMonitorName() + propertyId, propertyValue, defaultValue);
    }

    private boolean getBooleanProperty(@NotNull String propertyId, boolean defaultValue) {
        if (propertyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyId", "com/android/tools/idea/monitor/BaseMonitorView", "getBooleanProperty"));
        }
        return PropertiesComponent.getInstance((Project)this.myProject).getBoolean(this.getMonitorName() + propertyId, defaultValue);
    }

    private int getIntProperty(@NotNull String propertyId, int defaultValue) {
        if (propertyId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyId", "com/android/tools/idea/monitor/BaseMonitorView", "getIntProperty"));
        }
        return PropertiesComponent.getInstance((Project)this.myProject).getInt(this.getMonitorName() + propertyId, defaultValue);
    }

    private void performPausing(boolean paused) {
        ((DeviceSampler)this.mySampler).setIsPaused(paused);
        this.setOverlayEnabled(PAUSED_LABEL, paused);
    }

    private void updateOverlayText(String text) {
        this.myOverlayText.setText(text);
        this.myTextPanel.setVisible(!text.isEmpty());
        this.myTextPanel.invalidate();
    }

    private static class ZOrderedOverlayText {
        @NotNull
        private String myText;
        private int myZ;

        private ZOrderedOverlayText(@NotNull String text, int z) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/monitor/BaseMonitorView$ZOrderedOverlayText", "<init>"));
            }
            this.myText = text;
            this.myZ = z;
        }
    }
}

