/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

public abstract class BaseAsset {
    private final BoolProperty myTrimmed = new BoolValueProperty();
    private final IntProperty myPaddingPercent = new IntValueProperty();
    private final ObjectProperty<Color> myColor = new ObjectValueProperty<Color>(Color.BLACK);

    @NotNull
    public BoolProperty trimmed() {
        BoolProperty boolProperty = this.myTrimmed;
        if (boolProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/BaseAsset", "trimmed"));
        }
        return boolProperty;
    }

    @NotNull
    public IntProperty paddingPercent() {
        IntProperty intProperty = this.myPaddingPercent;
        if (intProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/BaseAsset", "paddingPercent"));
        }
        return intProperty;
    }

    @NotNull
    public ObjectProperty<Color> color() {
        ObjectProperty<Color> objectProperty = this.myColor;
        if (objectProperty == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/BaseAsset", "color"));
        }
        return objectProperty;
    }

    @NotNull
    public final BufferedImage toImage() {
        BufferedImage image = this.createAsImage((Color)this.myColor.get());
        if (((Boolean)this.myTrimmed.get()).booleanValue()) {
            image = AssetStudioUtils.trim(image);
        }
        BufferedImage bufferedImage = image = AssetStudioUtils.pad(image, (Integer)this.myPaddingPercent.get());
        if (bufferedImage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/BaseAsset", "toImage"));
        }
        return bufferedImage;
    }

    @NotNull
    protected abstract BufferedImage createAsImage(@NotNull Color var1);
}

