/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectedAndroidDevice
implements AndroidDevice {
    private static final ExtensionPointName<DeviceNameRendererEx> EP_NAME = ExtensionPointName.create((String)"com.android.run.deviceNameRenderer");
    @NotNull
    private final IDevice myDevice;
    @Nullable
    private final String myAvdName;
    @Nullable
    private final DeviceNameRendererEx myDeviceNameRenderer;

    public ConnectedAndroidDevice(@NotNull IDevice device, @Nullable List<AvdInfo> avdInfos) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ConnectedAndroidDevice", "<init>"));
        }
        this.myDevice = device;
        AvdInfo avdInfo = ConnectedAndroidDevice.getAvdInfo(device, avdInfos);
        this.myAvdName = avdInfo == null ? null : AvdManagerConnection.getAvdDisplayName(avdInfo);
        this.myDeviceNameRenderer = ConnectedAndroidDevice.getRendererExtension(device);
    }

    @Nullable
    private static AvdInfo getAvdInfo(@NotNull IDevice device, @Nullable List<AvdInfo> avdInfos) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ConnectedAndroidDevice", "getAvdInfo"));
        }
        if (avdInfos != null && device.isEmulator()) {
            for (AvdInfo info : avdInfos) {
                if (!info.getName().equals(device.getAvdName())) continue;
                return info;
            }
        }
        return null;
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return this.myDevice.isEmulator();
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        AndroidVersion androidVersion = this.myDevice.getVersion();
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getVersion"));
        }
        return androidVersion;
    }

    @Override
    public int getDensity() {
        return this.myDevice.getDensity();
    }

    @Override
    @NotNull
    public List<Abi> getAbis() {
        List abis = this.myDevice.getAbis();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String abi : abis) {
            Abi a = Abi.getEnum((String)abi);
            if (a == null) continue;
            builder.add((Object)a);
        }
        ImmutableList immutableList = builder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getAbis"));
        }
        return immutableList;
    }

    @Override
    @NotNull
    public String getSerial() {
        String avdName;
        if (this.myDevice.isEmulator() && (avdName = this.myDevice.getAvdName()) != null) {
            String string = avdName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getSerial"));
            }
            return string;
        }
        String string = this.myDevice.getSerialNumber();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getSerial"));
        }
        return string;
    }

    @Override
    public boolean supportsFeature(@NotNull IDevice.HardwareFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/android/tools/idea/run/ConnectedAndroidDevice", "supportsFeature"));
        }
        return this.myDevice.supportsFeature(feature);
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myDeviceNameRenderer != null) {
            String string = this.myDeviceNameRenderer.getName(this.myDevice);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getName"));
            }
            return string;
        }
        String string = this.myAvdName == null ? this.getDeviceName() : this.myAvdName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getName"));
        }
        return string;
    }

    @Override
    public void renderName(@NotNull SimpleColoredComponent renderer, boolean isCompatible, @Nullable String searchPrefix) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/android/tools/idea/run/ConnectedAndroidDevice", "renderName"));
        }
        if (this.myDeviceNameRenderer != null) {
            this.myDeviceNameRenderer.render(this.myDevice, (ColoredTextContainer)renderer);
            return;
        }
        renderer.setIcon(this.myDevice.isEmulator() ? AndroidIcons.Ddms.EmulatorDevice : AndroidIcons.Ddms.RealDevice);
        IDevice.DeviceState state = this.myDevice.getState();
        if (state != IDevice.DeviceState.ONLINE) {
            String name = String.format("%1$s [%2$s", this.myDevice.getSerialNumber(), this.myDevice.getState());
            renderer.append(name, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            if (state == IDevice.DeviceState.UNAUTHORIZED) {
                renderer.append(" - Press 'OK' in the 'Allow USB Debugging' dialog on your device", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            }
            renderer.append("] ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            return;
        }
        SimpleTextAttributes attr = isCompatible ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        SearchUtil.appendFragments((String)searchPrefix, (String)this.getName(), (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)renderer);
        String build = DevicePropertyUtil.getBuild(this.myDevice);
        if (!build.isEmpty()) {
            renderer.append(" (" + build + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private String getDeviceName() {
        StringBuilder name = new StringBuilder(20);
        name.append(DevicePropertyUtil.getManufacturer(this.myDevice, ""));
        if (name.length() > 0) {
            name.append(' ');
        }
        name.append(DevicePropertyUtil.getModel(this.myDevice, ""));
        return name.toString();
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> launch(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/ConnectedAndroidDevice", "launch"));
        }
        ListenableFuture<IDevice> listenableFuture = this.getLaunchedDevice();
        if (listenableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "launch"));
        }
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> getLaunchedDevice() {
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)this.myDevice);
        if (listenableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getLaunchedDevice"));
        }
        return listenableFuture;
    }

    @NotNull
    public IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "getDevice"));
        }
        return iDevice;
    }

    @Nullable
    private static DeviceNameRendererEx getRendererExtension(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/run/ConnectedAndroidDevice", "getRendererExtension"));
        }
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            return null;
        }
        for (DeviceNameRendererEx extensionRenderer : (DeviceNameRendererEx[])EP_NAME.getExtensions()) {
            if (!extensionRenderer.isApplicable(device)) continue;
            return extensionRenderer;
        }
        return null;
    }

    @Override
    @NotNull
    public LaunchCompatibility canRun(@NotNull AndroidVersion minSdkVersion, @NotNull IAndroidTarget projectTarget, @NotNull EnumSet<IDevice.HardwareFeature> requiredFeatures, @Nullable Set<String> supportedAbis) {
        if (minSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSdkVersion", "com/android/tools/idea/run/ConnectedAndroidDevice", "canRun"));
        }
        if (projectTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectTarget", "com/android/tools/idea/run/ConnectedAndroidDevice", "canRun"));
        }
        if (requiredFeatures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredFeatures", "com/android/tools/idea/run/ConnectedAndroidDevice", "canRun"));
        }
        LaunchCompatibility launchCompatibility = LaunchCompatibility.canRunOnDevice(minSdkVersion, projectTarget, requiredFeatures, supportedAbis, this);
        if (launchCompatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ConnectedAndroidDevice", "canRun"));
        }
        return launchCompatibility;
    }
}

