/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlBooleanEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlEnumEditor;
import com.android.tools.idea.uibuilder.property.editors.NlFlagEditor;
import com.android.tools.idea.uibuilder.property.editors.NlFlagsEditor;
import com.android.tools.idea.uibuilder.property.editors.NlReferenceEditor;
import com.android.tools.idea.uibuilder.property.editors.NlTableCellEditor;
import com.android.tools.idea.uibuilder.property.ptable.PTableCellEditor;
import com.android.tools.idea.uibuilder.property.ptable.PTableCellEditorProvider;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class NlPropertyEditors
implements PTableCellEditorProvider,
ProjectComponent,
LafManagerListener {
    private Project myProject;
    private NlTableCellEditor myBooleanEditor;
    private NlTableCellEditor myFlagEditor;
    private NlTableCellEditor myComboEditor;
    private NlTableCellEditor myDefaultEditor;

    @NotNull
    public static NlPropertyEditors getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getInstance"));
        }
        NlPropertyEditors nlPropertyEditors = (NlPropertyEditors)project.getComponent(NlPropertyEditors.class);
        if (nlPropertyEditors == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getInstance"));
        }
        return nlPropertyEditors;
    }

    private NlPropertyEditors(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "<init>"));
        }
        this.myProject = project;
    }

    @Override
    @NotNull
    public PTableCellEditor getCellEditor(@NotNull PTableItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getCellEditor"));
        }
        switch (NlPropertyEditors.getEditorType((NlProperty)((Object)item))) {
            case BOOLEAN: {
                PTableCellEditor pTableCellEditor = this.getBooleanEditor();
                if (pTableCellEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getCellEditor"));
                }
                return pTableCellEditor;
            }
            case FLAG: {
                PTableCellEditor pTableCellEditor = this.getMyFlagEditor();
                if (pTableCellEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getCellEditor"));
                }
                return pTableCellEditor;
            }
            case COMBO: 
            case COMBO_WITH_BROWSE: {
                PTableCellEditor pTableCellEditor = this.getMyComboEditor();
                if (pTableCellEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getCellEditor"));
                }
                return pTableCellEditor;
            }
        }
        PTableCellEditor pTableCellEditor = this.getDefaultEditor();
        if (pTableCellEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getCellEditor"));
        }
        return pTableCellEditor;
    }

    public NlComponentEditor create(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "create"));
        }
        switch (NlPropertyEditors.getEditorType(property)) {
            case BOOLEAN: {
                return NlBooleanEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            }
            case FLAG: {
                return NlFlagsEditor.create();
            }
            case COMBO: {
                return NlEnumEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
            }
            case COMBO_WITH_BROWSE: {
                return NlEnumEditor.createForInspectorWithBrowseButton(NlEditingListener.DEFAULT_LISTENER);
            }
        }
        return NlReferenceEditor.createForInspectorWithBrowseButton(property.getModel().getProject(), NlEditingListener.DEFAULT_LISTENER);
    }

    private void resetCachedEditors() {
        this.myBooleanEditor = null;
        this.myFlagEditor = null;
        this.myComboEditor = null;
        this.myDefaultEditor = null;
    }

    @NotNull
    private static EditorType getEditorType(@NotNull NlProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getEditorType"));
        }
        AttributeDefinition definition = property.getDefinition();
        Set<Object> formats = definition != null ? definition.getFormats() : Collections.emptySet();
        Boolean isBoolean = null;
        for (AttributeFormat attributeFormat : formats) {
            switch (attributeFormat) {
                case Boolean: {
                    if (isBoolean != null) break;
                    isBoolean = Boolean.TRUE;
                    break;
                }
                case String: 
                case Color: 
                case Dimension: 
                case Integer: 
                case Float: 
                case Fraction: {
                    if (isBoolean != null) break;
                    isBoolean = Boolean.FALSE;
                    break;
                }
                case Enum: {
                    EditorType editorType = EditorType.COMBO;
                    if (editorType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getEditorType"));
                    }
                    return editorType;
                }
                case Flag: {
                    EditorType editorType = EditorType.FLAG;
                    if (editorType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getEditorType"));
                    }
                    return editorType;
                }
            }
        }
        if (isBoolean == Boolean.TRUE) {
            EditorType editorType = EditorType.BOOLEAN;
            if (editorType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getEditorType"));
            }
            return editorType;
        }
        if (NlEnumEditor.supportsProperty(property)) {
            if (property.getName().equals("style")) {
                EditorType editorType = EditorType.COMBO_WITH_BROWSE;
                if (editorType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getEditorType"));
                }
                return editorType;
            }
            EditorType editorType = EditorType.COMBO;
            if (editorType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getEditorType"));
            }
            return editorType;
        }
        EditorType editorType = EditorType.DEFAULT;
        if (editorType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getEditorType"));
        }
        return editorType;
    }

    private PTableCellEditor getBooleanEditor() {
        if (this.myBooleanEditor == null) {
            this.myBooleanEditor = NlBooleanEditor.createForTable();
        }
        return this.myBooleanEditor;
    }

    public PTableCellEditor getMyFlagEditor() {
        if (this.myFlagEditor == null) {
            this.myFlagEditor = NlFlagEditor.createForTable();
        }
        return this.myFlagEditor;
    }

    private PTableCellEditor getMyComboEditor() {
        if (this.myComboEditor == null) {
            this.myComboEditor = NlEnumEditor.createForTable();
        }
        return this.myComboEditor;
    }

    private PTableCellEditor getDefaultEditor() {
        if (this.myDefaultEditor == null) {
            this.myDefaultEditor = NlReferenceEditor.createForTable(this.myProject);
        }
        return this.myDefaultEditor;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
        LafManager.getInstance().addLafManagerListener((LafManagerListener)this);
    }

    public void disposeComponent() {
        LafManager.getInstance().removeLafManagerListener((LafManagerListener)this);
    }

    public void lookAndFeelChanged(LafManager source) {
        this.resetCachedEditors();
    }

    @NotNull
    public String getComponentName() {
        String string = NlPropertyEditors.class.getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/NlPropertyEditors", "getComponentName"));
        }
        return string;
    }

    public static enum EditorType {
        DEFAULT,
        BOOLEAN,
        FLAG,
        COMBO,
        COMBO_WITH_BROWSE;

    }
}

