/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.agent;

import com.intellij.j2ee.webSphere.client.AdminClientWrapper;
import com.intellij.j2ee.webSphere.client.AppManagementNotificationListener;
import com.intellij.j2ee.webSphere.client.AppManagementWrapper;
import com.intellij.j2ee.webSphere.client.ApplicationWrapper;
import com.intellij.j2ee.webSphere.client.ServerNotificationListener;
import com.intellij.j2ee.webSphere.client.ServerWrapper;
import com.intellij.j2ee.webSphere.client.WebSphereClientException;
import com.intellij.j2ee.webSphere.client.WebSphereClientExceptionSeverity;
import com.intellij.j2ee.webSphere.client.WebSphereClientFactory;
import com.intellij.j2ee.webSphere.client.WebSphereClientFactoryImpl;
import com.intellij.javaee.oss.admin.DeploymentStatusWrapper;
import com.intellij.javaee.oss.agent.AgentCallback;
import com.intellij.javaee.oss.agent.AgentDeploymentCallback;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.VendorSpecificAgentBase;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.OutputWriter;
import com.intellij.javaee.util.AgentDeployStateChecker;
import com.intellij.javaee.util.AgentServerInstancePoller;
import com.intellij.javaee.util.IDeployStateChecker;
import java.io.File;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebSphereAgent
extends VendorSpecificAgentBase {
    private WebSphereClientFactory myClientFactory;
    private AdminClientWrapper myAdminClient;
    private ServerWrapper myServer;
    private AgentServerInstancePoller myPoller;
    private final Map<String, DeploymentStatusWrapper> myApplication2Status = new HashMap<String, DeploymentStatusWrapper>();

    public void init(String host, int port, String username, String password, ParametersMap initParameters, AgentCallback logger) {
        super.init(host, port, username, password, initParameters, logger);
        this.myClientFactory = new WebSphereClientFactoryImpl();
        this.myPoller = new AgentServerInstancePoller(this.getLog());
        this.myPoller.onInstanceStart();
    }

    public void destroy() {
        if (this.myPoller != null) {
            this.myPoller.onInstanceShutdown();
        }
    }

    public boolean connect() {
        try {
            if (!this.isClientCreated()) {
                this.createClient();
            }
            if (!this.isServerCreated()) {
                this.readProfile();
                this.createServer();
            }
            this.myServer.checkStarted();
            return true;
        }
        catch (WebSphereClientException e) {
            this.getLog().debugEx((Exception)((Object)WebSphereAgent.checkExceptionForSslCause(e)));
            return false;
        }
    }

    private boolean isClientCreated() {
        return this.myAdminClient != null;
    }

    private boolean isServerCreated() {
        return this.myServer != null;
    }

    private void createClient() throws WebSphereClientException {
        ParametersMap parametersMap = this.getInitParameters();
        this.myAdminClient = this.myClientFactory.createAdminClient(this.getHost(), this.getPort(), Boolean.parseBoolean((String)parametersMap.get((Object)"has.auto.upload")), this.getUsername(), this.getPassword(), Boolean.parseBoolean((String)parametersMap.get((Object)"is.secured")), (String)parametersMap.get((Object)"trust.store.path"), (String)parametersMap.get((Object)"trust.store.password"), (String)parametersMap.get((Object)"key.store.path"), (String)parametersMap.get((Object)"key.store.password"), Boolean.parseBoolean((String)parametersMap.get((Object)"is.use.ibm.algorithm")));
        this.myAdminClient.registerNotificationListener(new AppManagementNotificationListener(){

            public void handleNotification(String taskName, String taskStatus, String message, Properties properties) {
                WebSphereAgent.this.getLog().debug("Notification: task '" + taskName + "' " + taskStatus + ". " + message);
                this.checkCompleted(taskName, taskStatus, properties, "InstallApplication", DeploymentStatusWrapper.STATUS_DEPLOYED);
                this.checkCompleted(taskName, taskStatus, properties, "UninstallApplication", DeploymentStatusWrapper.STATUS_NOT_DEPLOYED);
            }

            private void checkCompleted(String taskName, String taskStatus, Properties properties, String checkedTaskName, DeploymentStatusWrapper completedStatus) {
                if (checkedTaskName.equals(taskName)) {
                    String appName = properties.getProperty("appname");
                    if (appName == null) {
                        return;
                    }
                    if ("Completed".equals(taskStatus)) {
                        WebSphereAgent.this.myApplication2Status.put(appName, completedStatus);
                    } else if ("Failed".equals(taskStatus)) {
                        WebSphereAgent.this.myApplication2Status.put(appName, DeploymentStatusWrapper.STATUS_FAILED);
                    }
                }
            }
        });
    }

    private void createServer() throws WebSphereClientException {
        ParametersMap parametersMap = this.getInitParameters();
        this.myServer = this.myAdminClient.createServer((String)parametersMap.get((Object)"cell.name"), (String)parametersMap.get((Object)"node.name"), (String)parametersMap.get((Object)"server.name"));
        this.myServer.addListener(new ServerNotificationListener(){

            public void handleNotification(String message) {
                WebSphereAgent.this.getLog().debug("server - handleNotification: " + message);
                WebSphereAgent.this.fireUpdateDeploymentStatus();
            }
        });
    }

    public void disconnect() {
        this.getLog().debug("disconnect");
        if (this.isClientCreated()) {
            this.myAdminClient.close();
        }
        this.myAdminClient = null;
        this.myServer = null;
    }

    public void startDeploy(final String deploymentName, File source, ParametersMap deployParameters, final AgentDeploymentCallback callback) {
        AppManagementWrapper appManagement;
        this.getLog().debug("startDeploy");
        this.myApplication2Status.put(deploymentName, DeploymentStatusWrapper.STATUS_UNKNOWN);
        try {
            appManagement = this.myAdminClient.createAppManagement();
        }
        catch (Exception e) {
            callback.setDeploymentStatusWithError(deploymentName, DeploymentStatusWrapper.STATUS_FAILED.getName(), e);
            return;
        }
        try {
            ParametersMap parametersMap = this.getInitParameters();
            appManagement.installApplication(source.getAbsolutePath(), deploymentName, (String)parametersMap.get((Object)"cell.name"), (String)parametersMap.get((Object)"node.name"), (String)parametersMap.get((Object)"server.name"), Boolean.parseBoolean((String)parametersMap.get((Object)"is.upload.ear.before.deploy")), Boolean.parseBoolean((String)deployParameters.get((Object)"ejb.deploy.enabled")));
        }
        catch (WebSphereClientException e) {
            callback.setDeploymentStatusWithError(deploymentName, DeploymentStatusWrapper.STATUS_FAILED.getName(), (Exception)((Object)e));
        }
        this.myPoller.putDeployStateChecker((IDeployStateChecker)new AgentDeployStateChecker(){

            public String getDeploymentModel() {
                return deploymentName;
            }

            public boolean check() {
                try {
                    if (appManagement.checkIfAppExists(deploymentName) && DeploymentStatusWrapper.STATUS_DEPLOYED.equals(WebSphereAgent.this.myApplication2Status.get(deploymentName))) {
                        if (WebSphereAgent.this.myAdminClient.findApplication(deploymentName) == null) {
                            appManagement.startApplication(deploymentName);
                        }
                        callback.setDeploymentStatus(deploymentName, DeploymentStatusWrapper.STATUS_DEPLOYED.getName());
                        return true;
                    }
                    if (DeploymentStatusWrapper.STATUS_FAILED.equals(WebSphereAgent.this.myApplication2Status.get(deploymentName))) {
                        callback.setDeploymentStatus(deploymentName, DeploymentStatusWrapper.STATUS_FAILED.getName());
                        return true;
                    }
                }
                catch (WebSphereClientException e) {
                    if (e.isConnectorSeverity()) {
                        WebSphereAgent.this.getLog().debugEx((Exception)((Object)e));
                    }
                    callback.setDeploymentStatusWithError(deploymentName, DeploymentStatusWrapper.STATUS_FAILED.getName(), (Exception)((Object)e));
                    return true;
                }
                return false;
            }
        });
    }

    public void startUndeploy(final String deploymentName, final AgentDeploymentCallback callback) {
        try {
            this.myApplication2Status.put(deploymentName, DeploymentStatusWrapper.STATUS_UNKNOWN);
            this.myAdminClient.createAppManagement().uninstallApplication(deploymentName);
            this.myPoller.putDeployStateChecker((IDeployStateChecker)new AgentDeployStateChecker(){

                public String getDeploymentModel() {
                    return deploymentName;
                }

                public boolean check() {
                    if (DeploymentStatusWrapper.STATUS_NOT_DEPLOYED.equals(WebSphereAgent.this.myApplication2Status.get(deploymentName))) {
                        callback.setDeploymentStatus(deploymentName, DeploymentStatusWrapper.STATUS_NOT_DEPLOYED.getName());
                        return true;
                    }
                    if (DeploymentStatusWrapper.STATUS_FAILED.equals(WebSphereAgent.this.myApplication2Status.get(deploymentName))) {
                        callback.setDeploymentStatus(deploymentName, DeploymentStatusWrapper.STATUS_FAILED.getName());
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (WebSphereClientException e) {
            callback.setDeploymentStatusWithError(deploymentName, DeploymentStatusWrapper.STATUS_UNKNOWN.getName(), (Exception)((Object)e));
        }
        catch (Exception e) {
            callback.setDeploymentStatusWithError(deploymentName, DeploymentStatusWrapper.STATUS_UNKNOWN.getName(), e);
        }
    }

    public void updateDeploymentStatus(String deploymentName, AgentDeploymentCallback callback) {
        try {
            this.getLog().debug("WebSphereInstanceImpl.updateDeploymentStatus");
            this.getLog().debug("server state = " + this.myServer.getState());
            ApplicationWrapper application = this.myAdminClient.findApplication(deploymentName);
            if (application == null) {
                this.getLog().debug("application '" + deploymentName + "' not found");
                callback.setDeploymentStatus(deploymentName, DeploymentStatusWrapper.STATUS_NOT_DEPLOYED.getName());
            } else {
                String[] modules = application.getModules();
                this.getLog().debug("modules = " + Arrays.asList(modules));
                callback.setDeploymentStatus(deploymentName, DeploymentStatusWrapper.STATUS_DEPLOYED.getName());
            }
        }
        catch (WebSphereClientException e) {
            DeploymentStatusWrapper status = e.isConnectorSeverity() ? DeploymentStatusWrapper.STATUS_UNKNOWN : DeploymentStatusWrapper.STATUS_FAILED;
            callback.setDeploymentStatusWithError(deploymentName, status.getName(), (Exception)((Object)e));
        }
    }

    private void readProfile() {
        try {
            this.getLog().info(WebSphereAgent.document2string(this.createServerNamesDocument()));
        }
        catch (JavaeeProcessUtilException e) {
            this.getLog().debugEx((Exception)((Object)e));
        }
        catch (WebSphereClientException e) {
            this.getLog().debugEx((Exception)((Object)e));
        }
    }

    private Document createServerNamesDocument() throws JavaeeProcessUtilException, WebSphereClientException {
        Document document = OutputWriter.createDocument();
        Element rootElement = document.createElement("profile");
        document.appendChild(rootElement);
        for (ServerWrapper serverWrapper : this.myAdminClient.getAllServers()) {
            Element cellElement = WebSphereAgent.getOrCreateChildNode(rootElement, "cells", "cell", serverWrapper.getCellName());
            Element nodeElement = WebSphereAgent.getOrCreateChildNode(cellElement, "nodes", "node", serverWrapper.getNodeName());
            WebSphereAgent.getOrCreateChildNode(nodeElement, "servers", "server", serverWrapper.getServerName());
        }
        return document;
    }

    private static Element getOrCreateChildNode(Element parentNode, String collectionName, String elementName, String value) {
        Element collectionNode;
        Document document = parentNode.getOwnerDocument();
        NodeList collectionNodeList = parentNode.getChildNodes();
        if (collectionNodeList.getLength() == 0) {
            collectionNode = document.createElement(collectionName);
            parentNode.appendChild(collectionNode);
        } else {
            collectionNode = (Element)collectionNodeList.item(0);
            NodeList childNodes = collectionNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element childNode = (Element)childNodes.item(i);
                if (!value.equals(childNode.getAttribute("name"))) continue;
                return childNode;
            }
        }
        Element result = document.createElement(elementName);
        result.setAttribute("name", value);
        collectionNode.appendChild(result);
        return result;
    }

    public static String document2string(Document document) throws JavaeeProcessUtilException {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        OutputWriter.putDocument((StreamResult)streamResult, (Document)document);
        return stringWriter.toString();
    }

    private static WebSphereClientException checkExceptionForSslCause(WebSphereClientException e) {
        Locale locale = Locale.getDefault();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MessageTester {
            final /* synthetic */ Locale val$locale;

            MessageTester(Locale locale) {
                this.val$locale = locale;
            }

            public boolean test(String text) {
                if (text == null) {
                    return false;
                }
                String lowerText = text.toLowerCase(this.val$locale);
                return lowerText.contains("faultCode=SOAP-ENV:Client;".toLowerCase(this.val$locale)) && lowerText.contains("Error parsing HTTP status line".toLowerCase(this.val$locale));
            }

            public boolean test(Throwable err) {
                return this.test(err.getMessage()) || this.test(err.getLocalizedMessage());
            }
        }
        MessageTester tester = new MessageTester(locale);
        for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
            if (!tester.test(cause)) continue;
            return new WebSphereClientException("SSL settings are missed: SSL fields must be filled in the run/debug configuration", WebSphereClientExceptionSeverity.SEVERITY_ERROR);
        }
        return e;
    }
}

