/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.highlighting;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.thymeleaf.lang.psi.ThymesMessagePropertyKey;
import com.intellij.thymeleaf.lang.psi.ThymesVisitor;
import com.intellij.thymeleaf.resources.ThymeleafBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ThymeleafMessagesResolveInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "ThymeleafMessagesResolveInspection";

    @NotNull
    public String getGroupDisplayName() {
        String string = ThymeleafBundle.message("thymeleaf.inspection.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/ThymeleafMessagesResolveInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = ThymeleafBundle.message("ThymeleafMessagesResolveInspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/ThymeleafMessagesResolveInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/ThymeleafMessagesResolveInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/thymeleaf/highlighting/ThymeleafMessagesResolveInspection", "buildVisitor"));
        }
        ThymesVisitor thymesVisitor = new ThymesVisitor(){

            @Override
            public void visitMessagePropertyKey(@NotNull ThymesMessagePropertyKey key) {
                PropertyReference propertyReference;
                ResolveResult[] results;
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/thymeleaf/highlighting/ThymeleafMessagesResolveInspection$1", "visitMessagePropertyKey"));
                }
                PsiReference reference = key.getReference();
                if (reference instanceof PropertyReference && (results = (propertyReference = (PropertyReference)reference).multiResolve(false)).length == 0) {
                    holder.registerProblem((PsiElement)key, propertyReference.getUnresolvedMessagePattern(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, propertyReference.getQuickFixes());
                }
            }
        };
        if (thymesVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/ThymeleafMessagesResolveInspection", "buildVisitor"));
        }
        return thymesVisitor;
    }
}

