/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.highlighting.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclareThymeleafVarInCommentFix
implements LocalQuickFix {
    protected String myVarId;

    public DeclareThymeleafVarInCommentFix(String varId) {
        this.myVarId = varId;
    }

    @NotNull
    public String getName() {
        String string = PsiBundle.message((String)"el.declare.variable.via.comment.annotation.intention.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/fixes/DeclareThymeleafVarInCommentFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PsiBundle.message((String)"el.declare.variable.intention.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/highlighting/fixes/DeclareThymeleafVarInCommentFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    protected PsiElement getContextElement(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile != null) {
            return containingFile.getContext();
        }
        return null;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/thymeleaf/highlighting/fixes/DeclareThymeleafVarInCommentFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/thymeleaf/highlighting/fixes/DeclareThymeleafVarInCommentFix", "applyFix"));
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile file = psiElement.getContainingFile();
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file.getVirtualFile()), false);
        if (editor == null) {
            return;
        }
        int templateStartOffset = -1;
        PsiElement contextElement = this.getContextElement(psiElement);
        if (contextElement instanceof XmlAttributeValue) {
            templateStartOffset = contextElement.getParent().getParent().getTextOffset();
        } else if (contextElement instanceof XmlTag) {
            templateStartOffset = ((XmlTag)contextElement).getValue().getTextRange().getStartOffset();
        }
        if (templateStartOffset != -1) {
            TemplateManager manager = TemplateManager.getInstance((Project)editor.getProject());
            Template template = manager.createTemplate("", "");
            template.addTextSegment("<!--/*");
            template.addTextSegment("@thymesVar");
            template.addTextSegment(" id=\"" + this.myVarId + "\"");
            template.addTextSegment(" type=\"");
            template.addVariable("type", (Expression)new MacroCallNode(MacroFactory.createMacro((String)"complete")), true);
            template.addTextSegment("\"");
            template.addEndVariable();
            template.addTextSegment("*/-->");
            CharSequence sequence = editor.getDocument().getCharsSequence();
            if (sequence.length() < templateStartOffset) {
                return;
            }
            if (sequence.charAt(templateStartOffset) != '\n') {
                template.addTextSegment("\n");
            }
            editor.getCaretModel().moveToOffset(templateStartOffset);
            manager.startTemplate(editor, template);
        }
    }
}

