/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.thymeleaf.lang.ThymeleafExpressionsFileType;
import com.intellij.thymeleaf.lang.ThymeleafLanguage;
import com.intellij.thymeleaf.lang.ThymeleafPsiFile;
import com.intellij.thymeleaf.lang.lexer.ThymeleafLexer;
import com.intellij.thymeleaf.lang.lexer.ThymeleafTokenTypeSets;
import com.intellij.thymeleaf.lang.lexer.ThymesElementTypes;
import com.intellij.thymeleaf.lang.parser.ThymesParser;
import org.jetbrains.annotations.NotNull;

public class ThymeleafParserDefinition
implements ParserDefinition {
    public static final IFileElementType THYMES_EXPRESSIONS_TYPE = new IFileElementType("THYMES_EXPRESSIONS_FILE", (Language)ThymeleafLanguage.EXPRESSIONS);
    public static final IFileElementType THYMES_EACH_EXPRESSIONS_TYPE = new IFileElementType("THYMES_EACH_FILE", (Language)ThymeleafLanguage.EACH_EXPRESSIONS);
    public static final IFileElementType THYMES_URL_EXPRESSIONS_TYPE = new IFileElementType("THYMES_URL_FILE", (Language)ThymeleafLanguage.URL_EXPRESSIONS);
    public static final IFileElementType THYMES_SPRING_SECURITY_TYPE = new IFileElementType("THYMES_SPRING_SECURITY_TYPE", (Language)ThymeleafLanguage.SPRING_SECURITY_EXPRESSIONS);
    public static final IFileElementType THYMES_TEMPLATES_EXPRESSIONS_TYPE = new IFileElementType("THYMES_TEMPLATES_EXPRESSIONS_TYPE", (Language)ThymeleafLanguage.TEMPLATES_EXPRESSIONS);

    @NotNull
    public Lexer createLexer(Project project) {
        ThymeleafLexer thymeleafLexer = new ThymeleafLexer();
        if (thymeleafLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafParserDefinition", "createLexer"));
        }
        return thymeleafLexer;
    }

    public PsiParser createParser(Project project) {
        return new ThymesParser();
    }

    public IFileElementType getFileNodeType() {
        return THYMES_EXPRESSIONS_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = ThymeleafTokenTypeSets.WHITESPACES;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = ThymesElementTypes.Factory.createElement(node);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafParserDefinition", "createElement"));
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new ThymeleafPsiFile(viewProvider, ThymeleafLanguage.EXPRESSIONS);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public static class TEMPLATES_EXPRESSIONS
    extends ThymeleafParserDefinition {
        @Override
        public IFileElementType getFileNodeType() {
            return THYMES_TEMPLATES_EXPRESSIONS_TYPE;
        }

        @Override
        public PsiFile createFile(FileViewProvider fileViewProvider) {
            return new ThymeleafPsiFile(fileViewProvider, ThymeleafLanguage.TEMPLATES_EXPRESSIONS){

                @Override
                @NotNull
                public FileType getFileType() {
                    ThymeleafExpressionsFileType thymeleafExpressionsFileType = ThymeleafExpressionsFileType.TEMPLATES_EXPRESSIONS;
                    if (thymeleafExpressionsFileType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafParserDefinition$TEMPLATES_EXPRESSIONS$1", "getFileType"));
                    }
                    return thymeleafExpressionsFileType;
                }
            };
        }
    }

    public static class SPRING_SECURITY_EXPRESSIONS
    extends ThymeleafParserDefinition {
        @Override
        public IFileElementType getFileNodeType() {
            return THYMES_SPRING_SECURITY_TYPE;
        }

        @Override
        public PsiFile createFile(FileViewProvider fileViewProvider) {
            return new ThymeleafPsiFile(fileViewProvider, ThymeleafLanguage.SPRING_SECURITY_EXPRESSIONS){

                @Override
                @NotNull
                public FileType getFileType() {
                    ThymeleafExpressionsFileType thymeleafExpressionsFileType = ThymeleafExpressionsFileType.SPRING_SECURITY_EXPRESSIONS;
                    if (thymeleafExpressionsFileType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafParserDefinition$SPRING_SECURITY_EXPRESSIONS$1", "getFileType"));
                    }
                    return thymeleafExpressionsFileType;
                }
            };
        }
    }

    public static class URL_EXPRESSIONS
    extends ThymeleafParserDefinition {
        @Override
        public IFileElementType getFileNodeType() {
            return THYMES_URL_EXPRESSIONS_TYPE;
        }

        @Override
        public PsiFile createFile(FileViewProvider fileViewProvider) {
            return new ThymeleafPsiFile(fileViewProvider, ThymeleafLanguage.URL_EXPRESSIONS){

                @Override
                @NotNull
                public FileType getFileType() {
                    ThymeleafExpressionsFileType thymeleafExpressionsFileType = ThymeleafExpressionsFileType.URL_EXPRESSIONS;
                    if (thymeleafExpressionsFileType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafParserDefinition$URL_EXPRESSIONS$1", "getFileType"));
                    }
                    return thymeleafExpressionsFileType;
                }
            };
        }
    }

    public static class ITERATE_EXPRESSIONS
    extends ThymeleafParserDefinition {
        @Override
        public IFileElementType getFileNodeType() {
            return THYMES_EACH_EXPRESSIONS_TYPE;
        }

        @Override
        public PsiFile createFile(FileViewProvider fileViewProvider) {
            return new ThymeleafPsiFile(fileViewProvider, ThymeleafLanguage.EACH_EXPRESSIONS){

                @Override
                @NotNull
                public FileType getFileType() {
                    ThymeleafExpressionsFileType thymeleafExpressionsFileType = ThymeleafExpressionsFileType.EACH_EXPRESSIONS;
                    if (thymeleafExpressionsFileType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafParserDefinition$ITERATE_EXPRESSIONS$1", "getFileType"));
                    }
                    return thymeleafExpressionsFileType;
                }
            };
        }
    }
}

