/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.thymeleaf.lang.psi.ThymesELMethodCallExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELReferencedVariable;
import com.intellij.thymeleaf.lang.psi.ThymesELSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELSliceExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesMessagesExpression;
import com.intellij.thymeleaf.lang.psi.ThymesOgnlExpression;
import com.intellij.thymeleaf.lang.psi.ThymesSelectionsExpression;
import com.intellij.thymeleaf.lang.psi.ThymesSpringElTypesExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafParserUtil {
    public static final Key<CachedValue<PsiType>> KEY = Key.create((String)"ThymeleafParserUtil.ExpressionType");

    @Nullable
    public static PsiType getType(@Nullable ThymesElExpression expression) {
        return expression == null ? null : (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)false, () -> ThymeleafParserUtil.getExpressionType(expression));
    }

    @Nullable
    public static PsiType getExpressionType(ThymesElExpression expression) {
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)expression, () -> CachedValueProvider.Result.create((Object)ThymeleafParserUtil.computeType(expression), (Object[])new Object[]{expression, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}));
    }

    @Nullable
    private static PsiType computeType(ThymesElExpression expression) {
        if (expression instanceof ThymesELVariable) {
            PsiElement resolve = ((ThymesELVariable)expression).resolve();
            if (resolve instanceof PsiVariable) {
                return ((PsiVariable)resolve).getType();
            }
            if (resolve instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)resolve;
                PsiType type = PropertyUtil.getPropertyType((PsiMember)method);
                if (type == null) {
                    type = method.getReturnType();
                }
                return ThymeleafParserUtil.getSubstitutedType((ThymesELVariable)expression, type);
            }
            if (resolve instanceof PsiClass) {
                return PsiTypesUtil.getClassType((PsiClass)((PsiClass)resolve));
            }
        } else {
            if (expression instanceof ThymesELReferencedVariable) {
                return ThymeleafParserUtil.getType(((ThymesELReferencedVariable)expression).getELVariable());
            }
            if (expression instanceof ThymesELSelectExpression) {
                return ThymeleafParserUtil.getType(((ThymesELSelectExpression)expression).getField());
            }
            if (expression instanceof ThymesELSliceExpression) {
                PsiType type = ThymeleafParserUtil.getType(((ThymesELSliceExpression)expression).getFrom());
                if (type instanceof PsiArrayType) {
                    return ((PsiArrayType)type).getComponentType();
                }
                PsiType collectionType = PsiUtil.extractIterableTypeParameter((PsiType)type, (boolean)false);
                if (collectionType != null) {
                    return collectionType;
                }
                return type;
            }
            if (expression instanceof ThymesMessagesExpression) {
                return PsiType.getJavaLangString((PsiManager)expression.getManager(), (GlobalSearchScope)expression.getResolveScope());
            }
            if (expression instanceof ThymesOgnlExpression) {
                return ThymeleafParserUtil.getType(((ThymesOgnlExpression)expression).getElExpression());
            }
            if (expression instanceof ThymesSelectionsExpression) {
                return ThymeleafParserUtil.getType(((ThymesSelectionsExpression)expression).getElExpression());
            }
            if (expression instanceof ThymesELMethodCallExpression) {
                PsiElement resolve;
                ThymesElExpression method = ((ThymesELMethodCallExpression)expression).getMethod();
                if (method instanceof ThymesELVariable && (resolve = ((ThymesELVariable)method).resolve()) instanceof PsiMethod) {
                    return ThymeleafParserUtil.getSubstitutedType((ThymesELVariable)method, ((PsiMethod)resolve).getReturnType());
                }
                return ThymeleafParserUtil.getType(method);
            }
            if (expression instanceof ThymesSpringElTypesExpression) {
                ThymesELSelectExpression selectExpression = ((ThymesSpringElTypesExpression)expression).getELSelectExpression();
                return ThymeleafParserUtil.getType(selectExpression);
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getSubstitutedType(ThymesELVariable expression, PsiType type) {
        PsiSubstitutor substitutor = ThymeleafParserUtil.getSubstitutor(expression);
        return substitutor != PsiSubstitutor.EMPTY && ThymeleafParserUtil.isValid(type) ? substitutor.substitute(type) : type;
    }

    private static boolean isValid(@Nullable PsiType type) {
        return type != null && type.isValid();
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(@NotNull ThymesELVariable expression) {
        ResolveResult[] results;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/thymeleaf/lang/psi/ThymeleafParserUtil", "getSubstitutor"));
        }
        for (ResolveResult result : results = expression.multiResolve(false)) {
            if (!(result instanceof CandidateInfo)) continue;
            PsiSubstitutor psiSubstitutor = ((CandidateInfo)result).getSubstitutor();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/psi/ThymeleafParserUtil", "getSubstitutor"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/psi/ThymeleafParserUtil", "getSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Nullable
    public static ThymesElExpression getMethod(ThymesELMethodCallExpression expression) {
        PsiElement sibling = expression.getParameterList().getPrevSibling();
        if (sibling instanceof ThymesELSelectExpression) {
            return ((ThymesELSelectExpression)sibling).getField();
        }
        if (sibling instanceof ThymesELVariable) {
            return (ThymesELVariable)sibling;
        }
        return null;
    }
}

