/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.psi.impl;

import com.intellij.ide.presentation.Presentation;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.thymeleaf.lang.psi.ThymesIterableVariable;
import com.intellij.thymeleaf.lang.psi.ThymesIterateExpression;
import com.intellij.thymeleaf.lang.psi.ThymesLocalVariableName;
import com.intellij.thymeleaf.lang.psi.impl.ThymeleafBaseLocalVariableImpl;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafPresentationProvider;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafPsiElementFactory;
import com.intellij.thymeleaf.providers.contexts.ThymeleafIterateVariablesProvider;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=ThymeleafPresentationProvider.class)
public abstract class ThymeleafIterateVariableImpl
extends ThymeleafBaseLocalVariableImpl
implements ThymesIterableVariable {
    private PsiType myType;

    public ThymeleafIterateVariableImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafIterateVariableImpl", "<init>"));
        }
        super(node);
    }

    public String getName() {
        return this.getLocalVariableName().getText();
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return this.getLocalVariableName();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafIterateVariableImpl", "setName"));
        }
        ThymesLocalVariableName localVariableName = this.getLocalVariableName();
        ThymesLocalVariableName child = ThymeleafPsiElementFactory.createIterateVariable(this.getProject(), name);
        localVariableName.replace((PsiElement)child);
        return this;
    }

    @Override
    @NotNull
    public PsiType getType() {
        ThymesIterateExpression iterateExpression;
        if (this.myType == null && (iterateExpression = (ThymesIterateExpression)PsiTreeUtil.getParentOfType((PsiElement)this, ThymesIterateExpression.class)) != null) {
            this.myType = ThymeleafIterateVariablesProvider.getIterateExpressionType(iterateExpression);
        }
        Object object = this.myType == null ? PsiType.NULL : this.myType;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/psi/impl/ThymeleafIterateVariableImpl", "getType"));
        }
        return object;
    }
}

