/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.api.impls.MethodParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.thymeleaf.lang.lexer.ThymesElementTypes;
import com.intellij.thymeleaf.lang.psi.ThymesELMethodCallExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesParameterList;
import com.intellij.thymeleaf.lang.support.ThymeleafElementProcessor;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafResolveUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ThymeleafParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<ThymesParameterList, PsiMember, ThymesElExpression> {
    public boolean couldShowInLookup() {
        return true;
    }

    @NotNull
    public Set<Class> getArgListStopSearchClasses() {
        Set<Class> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    public Object[] getParametersForDocumentation(PsiMember p, ParameterInfoContext context) {
        if (p instanceof PsiMethod) {
            return ((PsiMethod)p).getParameterList().getParameters();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public ThymesParameterList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        ThymesElExpression method;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "findElementForParameterInfo"));
        }
        ThymesELMethodCallExpression methodCallExpression = (ThymesELMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(context.getOffset()), ThymesELMethodCallExpression.class);
        if (methodCallExpression != null && (method = methodCallExpression.getMethod()) instanceof ThymesELVariable) {
            context.setItemsToShow((Object[])ThymeleafParameterInfoHandler.getMethodsByName((ThymesELVariable)method));
        }
        return methodCallExpression != null ? methodCallExpression.getParameterList() : null;
    }

    @NotNull
    private static PsiMember[] getMethodsByName(@NotNull ThymesELVariable method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "getMethodsByName"));
        }
        final HashSet members = ContainerUtil.newHashSet();
        final String methodName = method.getText();
        if (StringUtil.isNotEmpty((String)methodName)) {
            ThymeleafResolveUtil.processReference(method, new ThymeleafElementProcessor(){

                @Override
                public boolean processMethod(@NotNull PsiMethod variable, @NotNull PsiSubstitutor substitutor) {
                    if (variable == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler$1", "processMethod"));
                    }
                    if (substitutor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler$1", "processMethod"));
                    }
                    if (methodName.equals(variable.getName())) {
                        members.add(variable);
                    }
                    return true;
                }

                @Override
                public boolean processVariable(@NotNull PsiVariable variable, @NotNull PsiSubstitutor substitutor) {
                    if (variable == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler$1", "processVariable"));
                    }
                    if (substitutor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler$1", "processVariable"));
                    }
                    return true;
                }

                @Override
                public boolean processPackage(@NotNull PsiPackage psiPackage) {
                    if (psiPackage == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler$1", "processPackage"));
                    }
                    return true;
                }

                @Override
                public boolean processClass(@NotNull PsiClass psiClass) {
                    if (psiClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler$1", "processClass"));
                    }
                    return true;
                }
            });
        }
        PsiMember[] psiMemberArray = members.toArray(new PsiMember[members.size()]);
        if (psiMemberArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "getMethodsByName"));
        }
        return psiMemberArray;
    }

    public void showParameterInfo(@NotNull ThymesParameterList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public ThymesParameterList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return (ThymesParameterList)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(context.getOffset()), ThymesParameterList.class);
    }

    public void updateParameterInfo(@NotNull ThymesParameterList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterOwner", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "updateParameterInfo"));
        }
        if (context.getParameterOwner() != parameterOwner) {
            context.removeHint();
            return;
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)this.getActualParameterDelimiterType());
        context.setCurrentParameter(currentParameterIndex);
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(PsiMember p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "updateUI"));
        }
        if (p instanceof PsiMethod) {
            MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)((PsiMethod)p), (PsiSubstitutor)PsiSubstitutor.EMPTY, (ParameterInfoUIContext)context);
        } else {
            context.setupUIComponentPresentation(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]), -1, -1, false, false, false, context.getDefaultParameterColor());
        }
    }

    private static PsiParameter[] getParametersArray(FunctionDescriptor descriptor) {
        PsiMethod m = descriptor.getReferencedMethod();
        PsiParameterList list = m != null ? m.getParameterList() : null;
        return list != null ? list.getParameters() : PsiParameter.EMPTY_ARRAY;
    }

    @NotNull
    public ThymesElExpression[] getActualParameters(@NotNull ThymesParameterList o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "getActualParameters"));
        }
        List<ThymesElExpression> list = o.getElExpressionList();
        ThymesElExpression[] thymesElExpressionArray = list.toArray(new ThymesElExpression[list.size()]);
        if (thymesElExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "getActualParameters"));
        }
        return thymesElExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = ThymesElementTypes.COMMA;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = ThymesElementTypes.RPARENTH;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = Collections.singleton(ThymesELMethodCallExpression.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Class<ThymesParameterList> getArgumentListClass() {
        if (ThymesParameterList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/ThymeleafParameterInfoHandler", "getArgumentListClass"));
        }
        return ThymesParameterList.class;
    }
}

