/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.beans;

import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.thymeleaf.lang.support.ThymeleafElementProcessor;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafExpressionVariable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafVariable
extends LightVariableBuilder
implements ThymeleafExpressionVariable,
ItemPresentation {
    @NotNull
    private final String myName;
    @NotNull
    private final PsiType myType;
    @NotNull
    private final PsiElement myElement;

    public ThymeleafVariable(@NotNull String name, @NotNull PsiType type, @NotNull PsiElement navigationElement) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/thymeleaf/lang/support/beans/ThymeleafVariable", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/thymeleaf/lang/support/beans/ThymeleafVariable", "<init>"));
        }
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "com/intellij/thymeleaf/lang/support/beans/ThymeleafVariable", "<init>"));
        }
        super(name, type, navigationElement);
        this.myElement = navigationElement;
        this.myType = type;
        this.myName = name;
    }

    public String getPresentableText() {
        return this.getName();
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/thymeleaf/lang/support/beans/ThymeleafVariable", "replace"));
        }
        return super.replace(newElement);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = super.getNavigationElement();
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/beans/ThymeleafVariable", "getNavigationElement"));
        }
        return psiElement;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    public boolean processDeclarations(@NotNull ThymeleafElementProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/thymeleaf/lang/support/beans/ThymeleafVariable", "processDeclarations"));
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThymeleafVariable)) {
            return false;
        }
        ThymeleafVariable variable = (ThymeleafVariable)o;
        if (!this.myElement.equals(variable.myElement)) {
            return false;
        }
        if (!this.myName.equals(variable.myName)) {
            return false;
        }
        return this.myType.equals(variable.myType);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + this.myElement.hashCode();
        return result;
    }
}

