/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.references;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.thymeleaf.lang.psi.searchers.ThymeleafMethodReferenceSearcher;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafResolveUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class ThymeleafExpressionFilesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public ThymeleafExpressionFilesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<PsiReference> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/thymeleaf/references/ThymeleafExpressionFilesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/thymeleaf/references/ThymeleafExpressionFilesSearcher", "processQuery"));
        }
        PsiElement search = parameters.getElementToSearch();
        if (search instanceof PsiMethod) {
            ThymeleafMethodReferenceSearcher.searchMethod(parameters.getEffectiveSearchScope(), parameters.getOptimizer(), (PsiMethod)search);
        } else {
            String word;
            SearchScope effectiveSearchScope = parameters.getEffectiveSearchScope();
            if (effectiveSearchScope instanceof GlobalSearchScope) {
                effectiveSearchScope = ThymeleafResolveUtil.getThymeleafFilesScope(parameters.getProject(), (GlobalSearchScope)effectiveSearchScope);
            }
            if (search instanceof PsiVariable && (word = ((PsiVariable)search).getName()) != null) {
                parameters.getOptimizer().searchWord(word, effectiveSearchScope, (short)255, true, search);
            }
            if (search instanceof ThymeleafVariable) {
                parameters.getOptimizer().searchWord(((ThymeleafVariable)search).getName(), effectiveSearchScope, (short)255, true, search.getNavigationElement());
            }
        }
    }
}

