/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.impl.util.CssInHtmlClassOrIdReferenceProvider;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.lang.ThymeleafPsiFile;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import com.intellij.thymeleaf.lang.psi.ThymesTextIdentifier;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor", "registerReferenceProviders"));
        }
        ThymeleafReferenceContributor.registerFragmentAttributeProvider(registrar);
        ThymeleafReferenceContributor.registerCssAttributeProvider(registrar);
    }

    private static void registerCssAttributeProvider(PsiReferenceRegistrar registrar) {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("ThymeleafFragmentReference"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiElement contextElement;
                PsiFile containingFile;
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$1", "accepts"));
                }
                if (psiElement instanceof ThymesTextIdentifier && (containingFile = psiElement.getContainingFile()) instanceof ThymeleafPsiFile && (contextElement = containingFile.getContext()) != null) {
                    XmlAttribute contextAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)contextElement, XmlAttribute.class);
                    return contextAttribute != null && contextAttribute.getLocalName().contains("class");
                }
                return false;
            }
        });
        CssInHtmlClassOrIdReferenceProvider htmlClassOrIdReferenceProvider = new CssInHtmlClassOrIdReferenceProvider(){

            protected void doExtractReferences(@NotNull String text, @NotNull PsiElement element, @NotNull List<PsiReference> references, int offset) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$2", "doExtractReferences"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$2", "doExtractReferences"));
                }
                if (references == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$2", "doExtractReferences"));
                }
            }

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                PsiElement contextElement;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$2", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$2", "getReferencesByElement"));
                }
                PsiFile containingFile = element.getContainingFile();
                if (containingFile instanceof ThymeleafPsiFile && (contextElement = containingFile.getContext()) instanceof XmlAttributeValue) {
                    final LinkedList references = new LinkedList();
                    CssResolveUtil.consumeClassNames((String)element.getText(), (PsiElement)element, (PairConsumer)new PairConsumer<String, TextRange>(){

                        public void consume(String token, TextRange range) {
                            HtmlCssClassOrIdReference reference = new HtmlCssClassOrIdReference(element, range.getStartOffset(), range.getEndOffset(), true, true){

                                protected XmlTag getContextTag() {
                                    return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)contextElement, XmlTag.class);
                                }

                                protected XmlAttribute getContextAttribute() {
                                    return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)contextElement, XmlAttribute.class);
                                }

                                protected CssResolver getCssResolver() {
                                    CssResolver resolver = super.getCssResolver();
                                    resolver.setProcessAllCssFilesMode(true);
                                    return resolver;
                                }
                            };
                            references.add(reference);
                        }
                    });
                    PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$2", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$2", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        };
        registrar.registerReferenceProvider((ElementPattern)with, (PsiReferenceProvider)htmlClassOrIdReferenceProvider);
    }

    private static void registerFragmentAttributeProvider(PsiReferenceRegistrar registrar) {
        PsiElementPattern.Capture with = (PsiElementPattern.Capture)PlatformPatterns.psiElement().with((PatternCondition)new PatternCondition<PsiElement>("ThymeleafFragmentReference"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiElement contextElement;
                PsiFile containingFile;
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$3", "accepts"));
                }
                if (psiElement instanceof ThymesELVariable && (containingFile = psiElement.getContainingFile()) instanceof ThymeleafPsiFile && (contextElement = containingFile.getContext()) != null) {
                    XmlAttribute contextAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)contextElement, XmlAttribute.class);
                    return contextAttribute != null && "fragment".equals(contextAttribute.getLocalName());
                }
                return false;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)with, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$4", "getReferencesByElement"));
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new PsiReferenceBase<PsiElement>(element){

                    @Nullable
                    public PsiElement resolve() {
                        return element;
                    }

                    @NotNull
                    public Object[] getVariants() {
                        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$4$1", "getVariants"));
                        }
                        return ArrayUtil.EMPTY_OBJECT_ARRAY;
                    }

                    public TextRange getRangeInElement() {
                        return this.getElement().getTextRange();
                    }
                }};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/references/ThymeleafReferenceContributor$4", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }
}

