/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.descriptor;

import com.intellij.icons.AllIcons;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class BrowserVersion {
    public static final BrowserVersion[] EMPTY_ARRAY = new BrowserVersion[0];
    public static final Comparator<BrowserVersion> COMPARATOR = (o1, o2) -> o1.getBrowser().getPresentableName().compareTo(o2.getBrowser().getPresentableName());
    @NotNull
    private final Browser myBrowser;
    @NotNull
    private final String myVersion;

    public BrowserVersion(@NotNull Browser browser, @NotNull String version) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/intellij/psi/css/descriptor/BrowserVersion", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/psi/css/descriptor/BrowserVersion", "<init>"));
        }
        this.myBrowser = browser;
        this.myVersion = version;
    }

    @NotNull
    public String toString() {
        String string = this.myBrowser.getPresentableName() + ' ' + this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion", "toString"));
        }
        return string;
    }

    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion", "getVersion"));
        }
        return string;
    }

    @NotNull
    public Browser getBrowser() {
        Browser browser = this.myBrowser;
        if (browser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion", "getBrowser"));
        }
        return browser;
    }

    @NotNull
    public static BrowserVersion fromString(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/psi/css/descriptor/BrowserVersion", "fromString"));
        }
        if (!string.isEmpty()) {
            switch (string.charAt(0)) {
                case 'C': {
                    BrowserVersion browserVersion = new BrowserVersion(Browser.CHROME, string.substring(1));
                    if (browserVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion", "fromString"));
                    }
                    return browserVersion;
                }
                case 'F': {
                    BrowserVersion browserVersion = new BrowserVersion(Browser.FIREFOX, string.substring(2));
                    if (browserVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion", "fromString"));
                    }
                    return browserVersion;
                }
                case 'I': {
                    BrowserVersion browserVersion = new BrowserVersion(Browser.IE, string.substring(2));
                    if (browserVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion", "fromString"));
                    }
                    return browserVersion;
                }
                case 'O': {
                    BrowserVersion browserVersion = new BrowserVersion(Browser.OPERA, string.substring(1));
                    if (browserVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion", "fromString"));
                    }
                    return browserVersion;
                }
                case 'S': {
                    BrowserVersion browserVersion = new BrowserVersion(Browser.SAFARI, string.substring(1));
                    if (browserVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion", "fromString"));
                    }
                    return browserVersion;
                }
                case 'E': {
                    BrowserVersion browserVersion = new BrowserVersion(Browser.EDGE, string.substring(1));
                    if (browserVersion == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion", "fromString"));
                    }
                    return browserVersion;
                }
            }
        }
        throw new IllegalArgumentException("Can't create browser version for " + string);
    }

    public static enum Browser {
        CHROME("Chrome", AllIcons.Xml.Browsers.Chrome16),
        FIREFOX("Firefox", AllIcons.Xml.Browsers.Firefox16),
        SAFARI("Safari", AllIcons.Xml.Browsers.Safari16),
        OPERA("Opera", AllIcons.Xml.Browsers.Opera16),
        IE("IE", AllIcons.Xml.Browsers.Explorer16),
        EDGE("MS Edge", AllIcons.Xml.Browsers.Edge16);

        @NotNull
        private final Icon myIcon;
        @NotNull
        private final String myPresentableName;

        private Browser(String presentableName, Icon icon) {
            if (presentableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/psi/css/descriptor/BrowserVersion$Browser", "<init>"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/psi/css/descriptor/BrowserVersion$Browser", "<init>"));
            }
            this.myIcon = icon;
            this.myPresentableName = presentableName;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion$Browser", "getIcon"));
            }
            return icon;
        }

        @NotNull
        public String getPresentableName() {
            String string = this.myPresentableName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/BrowserVersion$Browser", "getPresentableName"));
            }
            return string;
        }
    }
}

