/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.annotator;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSBundle;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.psi.impl.LessImportType;

public class LessErrorsAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/annotator/LessErrorsAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/less/annotator/LessErrorsAnnotator", "annotate"));
        }
        Language stylesheetLanguage = CssPsiUtil.getStylesheetLanguage((PsiElement)element);
        if (stylesheetLanguage == LESSLanguage.INSTANCE) {
            if (element instanceof LessImportType) {
                for (ASTNode typeNode : ((LessImportType)element).getImportTypeNodes()) {
                    if (LessImportType.KNOWN_IMPORT_TYPES.contains(typeNode.getText().trim())) continue;
                    holder.createErrorAnnotation(typeNode, LESSBundle.message("annotator.unknown.import.type", new Object[0]));
                }
            } else if (element instanceof PsiComment) {
                CssInspectionsUtil.checkUnclosedComment((PsiComment)((PsiComment)element), (AnnotationHolder)holder);
            }
        }
    }
}

