/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.psi.LESSElementGenerator;
import org.jetbrains.plugins.less.psi.LessElement;

public class LESSMixinName
extends CompositePsiElement
implements LessElement {
    public static final TokenSet MIXIN_NAME_TOKENS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_FUNCTION_TOKEN, CssElementTypes.CSS_HASH, CssElementTypes.CSS_IDENT});

    public LESSMixinName() {
        super(LESSElementTypes.LESS_MIXIN_NAME);
    }

    protected LESSMixinName(IElementType type) {
        super(type);
    }

    public int getTextOffset() {
        PsiElement namedElement = this.getNamedElement();
        return namedElement == null || namedElement.getNode().getElementType() == CssElementTypes.CSS_HASH ? super.getTextOffset() : super.getTextOffset() + 1;
    }

    @NotNull
    public String getName() {
        String fullName = this.getFullName();
        String string = fullName.length() > 0 ? fullName.substring(1) : fullName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/psi/impl/LESSMixinName", "getName"));
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/less/psi/impl/LESSMixinName", "setName"));
        }
        LESSMixinName newElement = LESSElementGenerator.createMixinName(this.getProject(), this.createNewName(name));
        return newElement != null ? this.replace((PsiElement)newElement) : this;
    }

    protected String createNewName(String name) {
        return name.startsWith(".") || name.startsWith("#") ? name : this.getPrefix() + name;
    }

    public String getFullName() {
        return this.getText();
    }

    public PsiElement getNamedElement() {
        ASTNode[] children = this.getChildren(MIXIN_NAME_TOKENS);
        if (children.length > 0) {
            return children[0].getPsi();
        }
        return null;
    }

    public String getPrefix() {
        String fullName = this.getFullName();
        return fullName.length() > 0 ? fullName.substring(0, 1) : ".";
    }
}

