/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.LessParameter;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;
import org.jetbrains.plugins.less.references.LESSMixinReference;
import org.jetbrains.plugins.less.references.LESSVariableReference;

public class LessNamedArgumentReference
extends LESSVariableReference {
    public LessNamedArgumentReference(LESSVariableImpl lessVariable) {
        super(lessVariable);
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        Collection<ResolveResult> mixins = this.findResolvingMixin();
        if (mixins.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LessNamedArgumentReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ArrayList result = ContainerUtil.newArrayList();
        block0: for (ResolveResult mixinResolveResult : mixins) {
            PsiElement mixin = mixinResolveResult.getElement();
            if (!(mixin instanceof LESSMixin)) continue;
            for (LessParameter parameter : ((LESSMixin)mixin).getParameters()) {
                LESSVariableDeclaration variableDeclaration;
                if (!((LESSVariableImpl)this.myElement).getName().equals(parameter.getName()) || (variableDeclaration = parameter.getVariableDeclaration()) == null) continue;
                result.add(new PsiElementResolveResult((PsiElement)variableDeclaration, mixinResolveResult.isValidResult()));
                continue block0;
            }
        }
        ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LessNamedArgumentReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    private Collection<ResolveResult> findResolvingMixin() {
        LESSMixinInvocation mixinInvocation = (LESSMixinInvocation)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, LESSMixinInvocation.class);
        if (mixinInvocation != null) {
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiReference reference : mixinInvocation.getReferences()) {
                if (!(reference instanceof LESSMixinReference)) continue;
                Collections.addAll(result, ((LESSMixinReference)reference).multiResolve(false));
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LessNamedArgumentReference", "findResolvingMixin"));
            }
            return arrayList;
        }
        List<ResolveResult> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/references/LessNamedArgumentReference", "findResolvingMixin"));
        }
        return list;
    }
}

