/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.spellchecking;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSElementTypes;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.impl.LESSNamespace;
import org.jetbrains.plugins.less.psi.impl.LESSVariableImpl;

public class LessSpellcheckingStrategy
extends SpellcheckingStrategy {
    private static final Tokenizer SUBSTRING_TOKENIZER_FOR_NAME_OWNERS = new Tokenizer<PsiNameIdentifierOwner>(){

        public void tokenize(@NotNull PsiNameIdentifierOwner element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/spellchecking/LessSpellcheckingStrategy$1", "tokenize"));
            }
            PsiElement identifier = element.getNameIdentifier();
            if (identifier == null) {
                return;
            }
            TextRange range = identifier.getTextRange();
            if (range.isEmpty()) {
                return;
            }
            String text = identifier.getText().substring(1);
            consumer.consumeToken((PsiElement)element, text, true, 1, TextRange.allOf((String)text), (Splitter)IdentifierSplitter.getInstance());
        }
    };
    private static final Tokenizer SUBSTRING_TOKENIZER_FOR_NAME_IDENTIFIERS = new Tokenizer<PsiNamedElement>(){

        public void tokenize(@NotNull PsiNamedElement element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/less/spellchecking/LessSpellcheckingStrategy$2", "tokenize"));
            }
            String name = element.getName();
            if (StringUtil.isEmpty((String)name)) {
                return;
            }
            consumer.consumeToken((PsiElement)element, name, true, element.getTextOffset() - element.getTextRange().getStartOffset(), TextRange.allOf((String)name), (Splitter)IdentifierSplitter.getInstance());
        }
    };

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof LESSNamespace || element instanceof LESSMixinInvocation || element instanceof LESSMixin) {
            IElementType elementType;
            PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
            if (nameIdentifier != null && ((elementType = nameIdentifier.getNode().getElementType()) == CssElementTypes.CSS_HASH || elementType == LESSElementTypes.LESS_VARIABLE)) {
                Tokenizer tokenizer = SUBSTRING_TOKENIZER_FOR_NAME_OWNERS;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/spellchecking/LessSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
        } else {
            if (element instanceof LESSVariableImpl) {
                Tokenizer tokenizer = SUBSTRING_TOKENIZER_FOR_NAME_IDENTIFIERS;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/spellchecking/LessSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
            if (element instanceof LESSVariableDeclaration) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/spellchecking/LessSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/spellchecking/LessSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }
}

