/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config.anno;

import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.WebModelContributor;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.config.ServletFileSet;
import com.intellij.spring.web.config.anno.ServletContextServlet;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SpringMvcInitializerWebModelContributor
extends WebModelContributor {
    private static final Function<SpringModel, CommonServlet> SERVLET_CONTEXT_SERVLET_MAPPING = model -> {
        SpringFileSet set = model.getFileSet();
        if (!(set instanceof ServletFileSet)) {
            return null;
        }
        CommonServlet servlet = ((ServletFileSet)set).getServlet();
        if (!(servlet instanceof ServletContextServlet)) {
            return null;
        }
        return servlet;
    };
    private static final Function<CommonServlet, CommonServletMapping<CommonServlet>> SERVLET_MAPPING_FUNCTION = servlet -> {
        if (!(servlet instanceof CommonServletMapping)) {
            return null;
        }
        return (CommonServletMapping)servlet;
    };

    public List<CommonServlet> getServlets(Module module) {
        if (!SpringCommonUtils.hasSpringFacets((Project)module.getProject())) {
            return Collections.emptyList();
        }
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return Collections.emptyList();
        }
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary((Module)module)) {
            return Collections.emptyList();
        }
        WebFacet webFacet = (WebFacet)ContainerUtil.getFirstItem((Collection)WebFacet.getInstances((Module)module));
        if (webFacet == null) {
            return Collections.emptyList();
        }
        SpringMVCModel mvcModel = SpringMVCModelService.getInstance().getModel(webFacet, springFacet);
        if (mvcModel == null) {
            return Collections.emptyList();
        }
        return ContainerUtil.mapNotNull((Collection)mvcModel.getServletModels(), SERVLET_CONTEXT_SERVLET_MAPPING);
    }

    public List<CommonServletMapping<CommonServlet>> getServletMappings(Module module) {
        return ContainerUtil.mapNotNull(this.getServlets(module), SERVLET_MAPPING_FUNCTION);
    }
}

