/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.config.webXml;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.jam.SpringJamModel;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.web.config.ServletFileSet;
import com.intellij.spring.web.config.SpringWebModelContributor;
import com.intellij.spring.web.config.webXml.AnnotationServletFileSet;
import com.intellij.spring.web.mvc.SpringMvcBundle;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebXmlSpringWebModelContributor
extends SpringWebModelContributor {
    @NonNls
    private static final String APPLICATION_CONTEXT_FILESET = "web application context";

    public Pair<List<SpringFileSet>, Object[]> getFilesets(@NotNull SpringFacet springFacet, @NotNull WebFacet webFacet) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/webXml/WebXmlSpringWebModelContributor", "getFilesets"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/spring/web/config/webXml/WebXmlSpringWebModelContributor", "getFilesets"));
        }
        WebApp webApp = webFacet.getRoot();
        if (webApp == null) {
            return NO_RESULT;
        }
        VirtualFile webInf = WebXmlSpringWebModelContributor.getWebInf(webFacet);
        if (webInf == null) {
            return NO_RESULT;
        }
        PsiFile webXml = webApp.getContainingFile();
        VirtualFile root = webInf.getParent();
        SmartList servletFileSets = new SmartList();
        for (Servlet servlet : webApp.getServlets()) {
            SpringFileSet servletContextFileSet;
            String servletClass = servlet.getServletClass().getStringValue();
            String servletName = (String)servlet.getServletName().getValue();
            if (servletClass == null || servletName == null || !InheritanceUtil.isInheritor((PsiClass)((PsiClass)servlet.getServletClass().getValue()), (String)"org.springframework.web.servlet.DispatcherServlet")) continue;
            ParamValue param = (ParamValue)DomUtil.findByName((Collection)servlet.getInitParams(), (String)"contextConfigLocation");
            String id = "web " + servletName + " servlet context";
            String name = SpringMvcBundle.message("mvc.servlet.context.autodetected", servletName);
            if (param != null) {
                servletContextFileSet = WebXmlSpringWebModelContributor.createFileSet(root, param, id, name, springFacet, servlet, WebXmlSpringWebModelContributor.isAnnotationConfig(servlet.getInitParams()));
            } else {
                servletContextFileSet = WebXmlSpringWebModelContributor.createServletFileSet(id, name, springFacet, (CommonServlet)servlet, false);
                servletContextFileSet.addFile(webInf.getUrl() + "/" + WebXmlSpringWebModelContributor.getServletContextFileName(servletName));
            }
            servletFileSets.add(servletContextFileSet);
        }
        if (servletFileSets.isEmpty()) {
            return Pair.create((Object)servletFileSets, (Object)new Object[]{webXml});
        }
        ArrayList<SpringFileSet> result = new ArrayList<SpringFileSet>();
        SpringFileSet appContext = null;
        String filesetName = SpringMvcBundle.message("mvc.application.context.autodetected", new Object[0]);
        ParamValue param = (ParamValue)DomUtil.findByName((Collection)webApp.getContextParams(), (String)"contextConfigLocation");
        if (param != null) {
            boolean isAnnotationConfig = WebXmlSpringWebModelContributor.isAnnotationConfig(webApp.getContextParams());
            appContext = WebXmlSpringWebModelContributor.createFileSet(webInf.getParent(), param, APPLICATION_CONTEXT_FILESET, filesetName, springFacet, null, isAnnotationConfig);
        } else {
            VirtualFile file = webInf.findChild("applicationContext.xml");
            if (file != null) {
                appContext = WebXmlSpringWebModelContributor.createServletFileSet(APPLICATION_CONTEXT_FILESET, filesetName, springFacet, null, false);
                appContext.addFile(file);
            }
        }
        if (appContext != null) {
            result.add(appContext);
            for (SpringFileSet springFileSet : servletFileSets) {
                springFileSet.addDependency(appContext);
            }
        }
        result.addAll((Collection<SpringFileSet>)servletFileSets);
        return Pair.create(result, (Object)new Object[]{webXml});
    }

    @NonNls
    private static String getServletContextFileName(String servletName) {
        return servletName + "-servlet.xml";
    }

    @Nullable
    private static VirtualFile getWebInf(WebFacet facet) {
        WebDirectoryElement webInf = WebUtil.getWebUtil().findWebDirectoryElement("/WEB-INF/", facet);
        return webInf == null ? null : webInf.getVirtualFile();
    }

    private static boolean isAnnotationConfig(List<? extends ParamValue> paramValues) {
        ParamValue param = (ParamValue)DomUtil.findByName(paramValues, (String)"contextClass");
        if (param != null) {
            return "org.springframework.web.context.support.AnnotationConfigWebApplicationContext".equals(param.getParamValue().getStringValue());
        }
        return false;
    }

    @NotNull
    private static SpringFileSet createFileSet(VirtualFile root, ParamValue param, String id, String name, @NotNull SpringFacet springFacet, @Nullable Servlet servlet, boolean isAnnotationConfig) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/webXml/WebXmlSpringWebModelContributor", "createFileSet"));
        }
        SpringFileSet fileSet = WebXmlSpringWebModelContributor.createServletFileSet(id, name, springFacet, (CommonServlet)servlet, isAnnotationConfig);
        if (isAnnotationConfig) {
            String paramValue = param.getParamValue().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)paramValue)) {
                SpringFileSet springFileSet = fileSet;
                if (springFileSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/webXml/WebXmlSpringWebModelContributor", "createFileSet"));
                }
                return springFileSet;
            }
            Module module = springFacet.getModule();
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            StringTokenizer tokenizer = new StringTokenizer(paramValue, " ,;");
            while (tokenizer.hasMoreElements()) {
                String configText = tokenizer.nextElement().trim();
                if (StringUtil.isEmptyOrSpaces((String)configText)) continue;
                PsiPackage psiPackage = javaPsiFacade.findPackage(configText);
                if (psiPackage != null) {
                    GlobalSearchScope searchScope = moduleScope.intersectWith(PackageScope.packageScope((PsiPackage)psiPackage, (boolean)true));
                    List springConfigurations = SpringJamModel.getModel((Module)module).getConfigurations(searchScope);
                    for (SpringConfiguration springConfiguration : springConfigurations) {
                        WebXmlSpringWebModelContributor.addInFileset((SpringFileSet)fileSet, (PsiFile)springConfiguration.getContainingFile());
                    }
                    ((AnnotationServletFileSet)fileSet).addComponentScanPackage(psiPackage.getQualifiedName());
                    continue;
                }
                PsiClass psiClass = javaPsiFacade.findClass(configText, moduleScope);
                if (psiClass == null) continue;
                WebXmlSpringWebModelContributor.addInFileset((SpringFileSet)fileSet, (PsiFile)psiClass.getContainingFile());
            }
        } else {
            XmlElement tag = param.getParamValue().getXmlElement();
            if (tag != null) {
                PsiReference[] references;
                for (PsiReference reference : references = tag.getReferences()) {
                    if (!(reference instanceof FileReference) || !((FileReference)reference).isLast()) continue;
                    ResolveResult[] results = ((FileReference)reference).multiResolve(false);
                    boolean resolved = false;
                    for (ResolveResult resolveResult : results) {
                        VirtualFile virtualFile;
                        PsiElement element = resolveResult.getElement();
                        if (!(element instanceof PsiFileSystemItem) || ((PsiFileSystemItem)element).isDirectory() || (virtualFile = ((PsiFileSystemItem)element).getVirtualFile()) == null) continue;
                        fileSet.addFile(virtualFile);
                        resolved = true;
                    }
                    if (resolved) continue;
                    fileSet.addFile(root.getUrl() + "/" + ((FileReference)reference).getText());
                }
            }
        }
        SpringFileSet springFileSet = fileSet;
        if (springFileSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/config/webXml/WebXmlSpringWebModelContributor", "createFileSet"));
        }
        return springFileSet;
    }

    protected static SpringFileSet createServletFileSet(@NonNls String id, String name, @NotNull SpringFacet springFacet, @Nullable CommonServlet servlet, boolean isAnnotated) {
        if (springFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springFacet", "com/intellij/spring/web/config/webXml/WebXmlSpringWebModelContributor", "createServletFileSet"));
        }
        return isAnnotated ? new AnnotationServletFileSet(id, name, servlet, springFacet) : new ServletFileSet(id, name, servlet, springFacet);
    }
}

