/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.jam;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.web.mvc.jam.MVCPathVariable;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.spring.web.mvc.jam.RequestMappingUtil;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.jam.SpringMVCModelAttribute;
import com.intellij.spring.web.mvc.jam.SpringRequestMapping;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringMvcApiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=CustomRequestPresentationProvider.class)
public abstract class CustomRequestMapping<T extends PsiMember>
implements RequestMapping<T> {
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final JamAnnotationMeta myAnnotationMeta;
    private final PsiAnchor myPsiClassAnchor;
    private final NullableLazyValue<SpringRequestMapping.ClassMapping> myDefiningMetaAnnotation;
    private final Function<JamStringAttributeElement<String>, PsiTarget> myPsiTargetMapping;

    CustomRequestMapping(@NotNull String anno, @NotNull T psiElement) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/web/mvc/jam/CustomRequestMapping", "<init>"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/web/mvc/jam/CustomRequestMapping", "<init>"));
        }
        this.myDefiningMetaAnnotation = new NullableLazyValue<SpringRequestMapping.ClassMapping>(){

            @Nullable
            protected SpringRequestMapping.ClassMapping compute() {
                PsiAnnotation definingMetaAnnotation = SpringAliasForUtils.findDefiningMetaAnnotation(CustomRequestMapping.this.getPsiElement(), (String)CustomRequestMapping.this.myAnnotationMeta.getAnnoName(), (String)"org.springframework.web.bind.annotation.RequestMapping");
                if (definingMetaAnnotation == null) {
                    return null;
                }
                PsiClass annotationType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)definingMetaAnnotation, PsiClass.class, (boolean)true);
                if (annotationType == null) {
                    return null;
                }
                return (SpringRequestMapping.ClassMapping)SpringRequestMapping.ClassMapping.META.getJamElement((PsiModifierListOwner)annotationType);
            }
        };
        this.myPsiTargetMapping = url -> url.getPsiLiteral() == null ? null : new JamPomTarget((JamElement)this, url);
        this.myAnnotationMeta = new JamAnnotationMeta(anno);
        this.myPsiClassAnchor = PsiAnchor.create(psiElement);
        this.myPsiAnnotation = this.myAnnotationMeta.getAnnotationRef(this.getPsiElement());
    }

    @Override
    public List<JamStringAttributeElement<String>> getMappingUrls() {
        SpringAliasFor valueAliasFor = this.findAliasFor("value");
        SpringAliasFor pathAliasFor = this.findAliasFor("path");
        if (valueAliasFor == null && pathAliasFor == null) {
            SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
            return definingAnnotation != null ? definingAnnotation.getMappingUrls() : Collections.emptyList();
        }
        List<JamStringAttributeElement<String>> valueElements = this.getCollectionStringAttributeElements(valueAliasFor);
        List<JamStringAttributeElement<String>> pathElements = this.getCollectionStringAttributeElements(pathAliasFor);
        return ContainerUtil.concat(valueElements, pathElements);
    }

    @NotNull
    private List<JamStringAttributeElement<String>> getCollectionStringAttributeElements(SpringAliasFor aliasFor) {
        List list = aliasFor == null ? Collections.emptyList() : JamAttributeMeta.collectionString((String)aliasFor.getMethodName()).getJam(this.myPsiAnnotation);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/jam/CustomRequestMapping", "getCollectionStringAttributeElements"));
        }
        return list;
    }

    @Override
    public List<String> getUrls() {
        List<JamStringAttributeElement<String>> urlElements = this.getMappingUrls();
        List<String> urls = SpringRequestMapping.mapToStringList(urlElements);
        if (!urls.isEmpty()) {
            return urls;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getUrls() : Collections.emptyList();
    }

    @Override
    public RequestMethod[] getMethods() {
        SpringAliasFor aliasFor = this.findAliasFor("method");
        if (aliasFor == null) {
            SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
            return definingAnnotation != null ? definingAnnotation.getMethods() : new RequestMethod[]{};
        }
        JamEnumAttributeMeta.Collection attributeMeta = new JamEnumAttributeMeta.Collection(aliasFor.getMethodName(), RequestMethod.class);
        List methods = ContainerUtil.mapNotNull((Collection)attributeMeta.getJam(this.myPsiAnnotation), JamEnumAttributeElement::getValue);
        return methods.toArray(new RequestMethod[methods.size()]);
    }

    @Override
    public List<String> getConsumes() {
        List<String> values = this.getStringValues("consumes");
        if (values != null) {
            return values;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getConsumes() : Collections.emptyList();
    }

    @Override
    public List<String> getProduces() {
        List<String> values = this.getStringValues("produces");
        if (values != null) {
            return values;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getProduces() : Collections.emptyList();
    }

    @Override
    public List<String> getParams() {
        List<String> values = this.getStringValues("params");
        if (values != null) {
            return values;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getParams() : Collections.emptyList();
    }

    @Override
    public List<String> getHeaders() {
        List<String> values = this.getStringValues("headers");
        if (values != null) {
            return values;
        }
        SpringRequestMapping.ClassMapping definingAnnotation = this.getDefiningAnnotation();
        return definingAnnotation != null ? definingAnnotation.getHeaders() : Collections.emptyList();
    }

    @Override
    public T getPsiElement() {
        return (T)((PsiMember)this.myPsiClassAnchor.retrieve());
    }

    @Nullable
    protected List<String> getStringValues(String attributeName) {
        SpringAliasFor aliasFor = this.findAliasFor(attributeName);
        if (aliasFor == null) {
            return null;
        }
        JamStringAttributeMeta.Collection stringAttributeMeta = JamAttributeMeta.collectionString((String)aliasFor.getMethodName());
        return SpringRequestMapping.mapToStringList(stringAttributeMeta.getJam(this.myPsiAnnotation));
    }

    @Nullable
    private SpringAliasFor findAliasFor(@NotNull String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/web/mvc/jam/CustomRequestMapping", "findAliasFor"));
        }
        return SpringAliasForUtils.findAliasFor(this.getPsiElement(), (String)this.myAnnotationMeta.getAnnoName(), (String)"org.springframework.web.bind.annotation.RequestMapping", (String)attrName);
    }

    protected List<PsiTarget> getPomTargets() {
        return ContainerUtil.mapNotNull(this.getMappingUrls(), this.myPsiTargetMapping);
    }

    @Nullable
    protected SpringRequestMapping.ClassMapping getDefiningAnnotation() {
        return (SpringRequestMapping.ClassMapping)this.myDefiningMetaAnnotation.getValue();
    }

    public static class CustomRequestPresentationProvider
    extends PresentationProvider {
        @Nullable
        public String getTypeName(Object o) {
            if (!(o instanceof CustomRequestMapping)) {
                return null;
            }
            String annotationName = ((CustomRequestMapping)o).myAnnotationMeta.getAnnoName();
            return "@" + StringUtil.getShortName((String)annotationName);
        }

        @Nullable
        public Icon getIcon(Object o) {
            return SpringMvcApiIcons.RequestMapping;
        }
    }

    public static class MethodMapping
    extends CustomRequestMapping<PsiMethod>
    implements RequestMapping.Method {
        static final SemKey<MethodMapping> JAM_KEY = RequestMapping.METHOD_JAM_KEY.subKey("CustomMethodMapping", new SemKey[0]);
        private static final JamMethodMeta<MethodMapping> META = new JamMethodMeta(null, MethodMapping.class, JAM_KEY);
        static final SemKey<JamMemberMeta<PsiMethod, MethodMapping>> META_KEY = META.getMetaKey().subKey("CustomMethodMappingMeta", new SemKey[0]);

        MethodMapping(@NotNull String anno, @NotNull PsiMethod psiElement) {
            if (anno == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/web/mvc/jam/CustomRequestMapping$MethodMapping", "<init>"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/web/mvc/jam/CustomRequestMapping$MethodMapping", "<init>"));
            }
            super(anno, psiElement);
        }

        @Override
        public RequestMethod[] getMethods() {
            return RequestMappingUtil.getAllRequestMethods(this);
        }

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return MODEL_ATTRIBUTE_PARAMETERS_QUERY.findChildren(PsiElementRef.real(this.getPsiElement()));
        }

        @Override
        public RequestMethod[] getLocalMethods() {
            return super.getMethods();
        }

        @Override
        @Nullable
        public RequestMapping<PsiClass> getClassLevelMapping() {
            return RequestMappingUtil.getClassLevelMapping(this);
        }

        @Override
        public List<MVCPathVariable> getPathVariables() {
            return PATH_VARIABLE_PARAMETERS_QUERY.findChildren(PsiElementRef.real(this.getPsiElement()));
        }

        static Consumer<JamMemberMeta<PsiMethod, MethodMapping>> createMetaConsumer() {
            return meta -> meta.addChildrenQuery(MODEL_ATTRIBUTE_PARAMETERS_QUERY).addChildrenQuery(PATH_VARIABLE_PARAMETERS_QUERY).addPomTargetProducer((method, consumer) -> {
                for (PsiTarget target : method.getPomTargets()) {
                    consumer.consume((Object)target);
                }
            });
        }
    }

    static class ClassMapping
    extends CustomRequestMapping<PsiClass> {
        static final SemKey<ClassMapping> JAM_KEY = RequestMapping.CLASS_JAM_KEY.subKey("CustomClassMapping", new SemKey[0]);
        private static final JamClassMeta<ClassMapping> META = new JamClassMeta(null, ClassMapping.class, JAM_KEY);
        static final SemKey<JamMemberMeta<PsiClass, ClassMapping>> META_KEY = META.getMetaKey().subKey("CustomClassMappingMeta", new SemKey[0]);

        ClassMapping(@NotNull String anno, @NotNull PsiClass psiElement) {
            if (anno == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/web/mvc/jam/CustomRequestMapping$ClassMapping", "<init>"));
            }
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/web/mvc/jam/CustomRequestMapping$ClassMapping", "<init>"));
            }
            super(anno, psiElement);
        }

        @Override
        public List<SpringMVCModelAttribute> getModelAttributes() {
            return MODEL_ATTRIBUTE_METHODS_QUERY.findChildren(PsiElementRef.real(this.getPsiElement()));
        }

        static Consumer<JamMemberMeta<PsiClass, ClassMapping>> createMetaConsumer() {
            return meta -> meta.addChildrenQuery(MODEL_ATTRIBUTE_METHODS_QUERY).addPomTargetProducer((clazz, consumer) -> {
                for (PsiTarget target : clazz.getPomTargets()) {
                    consumer.consume((Object)target);
                }
            });
        }
    }
}

