/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jam.JamService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiNameValuePairPattern;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.web.mvc.SpringControllerClassInfo;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.jam.MVCPathVariable;
import com.intellij.spring.web.mvc.jam.RequestMapping;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MVCPathVariableReference
extends PsiPolyVariantReferenceBase<PsiExpression>
implements EmptyResolveMessageProvider,
LocalQuickFixProvider {
    static final PatternCondition<PsiAnnotation> REQUEST_MAPPING_ANNOTATION = new PatternCondition<PsiAnnotation>("RequestMapping"){

        public boolean accepts(@NotNull PsiAnnotation annotation, ProcessingContext context) {
            if (annotation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReference$1", "accepts"));
            }
            if ("org.springframework.web.bind.annotation.RequestMapping".equals(annotation.getQualifiedName())) {
                return true;
            }
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class);
            if (modifierListOwner == null) {
                return false;
            }
            if (modifierListOwner instanceof PsiMethod) {
                return SpringControllerClassInfo.isJamRequestHandler((PsiMethod)modifierListOwner);
            }
            if (modifierListOwner instanceof PsiClass) {
                return modifierListOwner.hasModifierProperty("public") && JamService.getJamService((Project)modifierListOwner.getProject()).getJamElement(RequestMapping.CLASS_JAM_KEY, (PsiElement)modifierListOwner) != null;
            }
            return false;
        }
    };
    static final PsiJavaElementPattern.Capture<PsiLiteralExpression> PATTERN = MVCPathVariableReference.createPattern(PsiLiteralExpression.class);
    private static final Function<MVCPathVariable, Object> VARIANT_MAPPER = mvcPathVariable -> {
        PsiParameter psiParameter = mvcPathVariable.getPsiElement();
        return LookupElementBuilder.create((Object)psiParameter, (String)mvcPathVariable.getName()).withIcon(SpringApiIcons.SpringProperty).withTypeText(psiParameter.getType().getPresentableText());
    };

    static <T extends PsiExpression> PsiJavaElementPattern.Capture<T> createPattern(Class<T> psiElementClass) {
        return (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(psiElementClass).with(SpringMvcLibraryUtil.IS_SPRING_MVC_PROJECT)).withAncestor(3, (ElementPattern)((PsiNameValuePairPattern)PsiJavaPatterns.psiNameValuePair().withName(new String[]{"value", "path"})).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class).withParent((ElementPattern)PsiJavaPatterns.psiAnnotation().with(REQUEST_MAPPING_ANNOTATION))));
    }

    MVCPathVariableReference(PsiLiteralExpression ex, TextRange textRange) {
        super((PsiElement)ex, textRange.shiftRight(1));
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = ContainerUtil.map2Array(this.collectVariables(false), VARIANT_MAPPER);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        if ("Cannot resolve @PathVariable ''{0}''" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReference", "getUnresolvedMessagePattern"));
        }
        return "Cannot resolve @PathVariable ''{0}''";
    }

    public LocalQuickFix[] getQuickFixes() {
        final String value = this.getValue();
        if (StringUtil.isEmpty((String)value) || MVCPathVariableReference.getMethodsToFix(this.getElement(), value).isEmpty()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = "Create @PathVariable parameter '" + value + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReference$2", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                if ("Create @PathVariable parameter" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReference$2", "getFamilyName"));
                }
                return "Create @PathVariable parameter";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReference$2", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReference$2", "applyFix"));
                }
                PsiElement element = descriptor.getPsiElement();
                List methodsToFix = MVCPathVariableReference.getMethodsToFix(element, value);
                for (PsiMethod psiMethod : methodsToFix) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiMethod.getProject()).getElementFactory();
                    try {
                        PsiParameter parameter = factory.createParameterFromText("@PathVariable(\"" + value + "\") String " + value, (PsiElement)psiMethod);
                        psiMethod.getParameterList().add((PsiElement)parameter);
                    }
                    catch (IncorrectOperationException e) {
                        Messages.showErrorDialog((String)("Error applying fix for '" + value + "'"), (String)"Error");
                    }
                }
            }
        }};
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        Collection<MVCPathVariable> results = this.collectVariables(true);
        ResolveResult[] resolveResultArray = (ResolveResult[])ContainerUtil.map2Array(results, ResolveResult.class, variable -> new PsiElementResolveResult(PomService.convertToPsi((PsiTarget)variable.getPomTarget())));
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    private Collection<MVCPathVariable> collectVariables(final boolean matchingOnly) {
        final String s = this.getValue();
        CommonProcessors.CollectProcessor<MVCPathVariable> processor = new CommonProcessors.CollectProcessor<MVCPathVariable>(){

            protected boolean accept(MVCPathVariable mvcPathVariable) {
                if (matchingOnly) {
                    return s.equals(mvcPathVariable.getName());
                }
                return true;
            }
        };
        MVCPathVariableReference.processPathVariables((PsiExpression)this.getElement(), (Processor<MVCPathVariable>)processor);
        return processor.getResults();
    }

    private static List<PsiMethod> getMethodsToFix(PsiElement element, final String value) {
        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiVariable.class);
        if (variable != null) {
            return Collections.emptyList();
        }
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (psiMethod != null) {
            return Collections.singletonList(psiMethod);
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass != null) {
            return ContainerUtil.filter((Object[])psiClass.getMethods(), method -> {
                if (!SpringControllerClassInfo.isJamRequestHandler(method)) {
                    return false;
                }
                return MVCPathVariableReference.processMethod(method, (Processor<MVCPathVariable>)new CommonProcessors.FindProcessor<MVCPathVariable>(){

                    protected boolean accept(MVCPathVariable mvcPathVariable) {
                        return value.equals(mvcPathVariable.getName());
                    }
                });
            });
        }
        return Collections.emptyList();
    }

    private static void processPathVariables(PsiExpression ex, Processor<MVCPathVariable> processor) {
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)ex, PsiMethod.class);
        if (method != null) {
            MVCPathVariableReference.processMethod(method, processor);
            return;
        }
        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)ex, PsiVariable.class);
        if (variable != null) {
            ReferencesSearch.search((PsiElement)variable).forEach(reference -> {
                PsiMethod usingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiMethod.class);
                if (usingMethod != null) {
                    return MVCPathVariableReference.processMethod(usingMethod, processor);
                }
                return true;
            });
            return;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ex, PsiClass.class);
        if (psiClass != null) {
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                if (MVCPathVariableReference.processMethod(psiMethod, processor)) continue;
                return;
            }
        }
    }

    private static boolean processMethod(PsiMethod method, Processor<MVCPathVariable> processor) {
        PsiParameterList parameterList = method.getParameterList();
        for (PsiParameter parameter : parameterList.getParameters()) {
            MVCPathVariable variable = (MVCPathVariable)MVCPathVariable.META.getJamElement((PsiModifierListOwner)parameter);
            if (variable == null || processor.process((Object)variable)) continue;
            return false;
        }
        return true;
    }
}

