/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.tiles;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.struts.StrutsPluginDomFactory;
import com.intellij.struts.StrutsProjectComponent;
import com.intellij.struts.TilesModel;
import com.intellij.struts.dom.tiles.Definition;
import com.intellij.struts.dom.tiles.Put;
import com.intellij.struts.dom.tiles.TilesDefinitions;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import icons.StrutsApiIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TilesViewResolver
extends ViewResolver {
    private final StrutsPluginDomFactory<TilesDefinitions, TilesModel> myTilesFactory;
    private final Module myModule;

    TilesViewResolver(SpringModel model) {
        this.myModule = model.getModule();
        assert (this.myModule != null);
        this.myTilesFactory = StrutsProjectComponent.getInstance((Project)this.myModule.getProject()).getTilesFactory();
    }

    public PsiElement resolveView(String viewName, SpringMVCModel springMVCModel) {
        Definition definition = this.findDefinition(viewName);
        if (definition == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget((DomElement)definition);
        if (target == null) {
            return null;
        }
        return PomService.convertToPsi((PsiTarget)target);
    }

    public PsiElement resolveFinalView(String viewName, SpringMVCModel springMVCModel) {
        Definition definition = this.findDefinition(viewName);
        if (definition == null) {
            return null;
        }
        return TilesViewResolver.resolveDefinitionTarget(definition, springMVCModel);
    }

    @Nullable
    private static PsiFile resolveDefinitionTarget(@NotNull Definition definition, SpringMVCModel context) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/spring/web/mvc/tiles/TilesViewResolver", "resolveDefinitionTarget"));
        }
        List puts = definition.getAllPuts();
        for (Put put : puts) {
            WebDirectoryElement webDirectoryElement;
            Definition inner = put.getDefinition();
            PsiFile directoryElement = TilesViewResolver.resolveDefinitionTarget(inner, context);
            if (directoryElement != null) {
                return directoryElement;
            }
            String value = put.getValue();
            if (StringUtil.isEmpty((String)value)) {
                value = put.getAttributeValue().getStringValue();
            }
            if (value == null || !StringUtil.isNotEmpty((String)value) || (webDirectoryElement = context.findWebDirectoryElement(value)) == null) continue;
            return webDirectoryElement.getOriginalFile();
        }
        return null;
    }

    public List<LookupElement> getAllViews(SpringMVCModel context) {
        TilesModel tilesModel = this.getTilesModel();
        if (tilesModel == null) {
            return Collections.emptyList();
        }
        ArrayList<LookupElement> lookupElements = new ArrayList<LookupElement>();
        for (Definition definition : tilesModel.getDefinitions()) {
            DomTarget target = DomTarget.getTarget((DomElement)definition);
            if (target == null || target.getName() == null) continue;
            PsiElement resolvePsiElement = target.getNavigationElement();
            LookupElementBuilder lookupElement = LookupElementBuilder.create((Object)resolvePsiElement, (String)target.getName()).withIcon(StrutsApiIcons.Tiles.Tile).withTypeText(resolvePsiElement.getContainingFile().getName());
            lookupElements.add((LookupElement)lookupElement);
        }
        return lookupElements;
    }

    public String bindToElement(PsiElement element) {
        return null;
    }

    @NotNull
    public String handleElementRename(String newElementName) {
        String string = newElementName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/tiles/TilesViewResolver", "handleElementRename"));
        }
        return string;
    }

    @Nullable
    private TilesModel getTilesModel() {
        return (TilesModel)this.myTilesFactory.getCombinedModel((UserDataHolder)this.myModule);
    }

    @Nullable
    private Definition findDefinition(String viewName) {
        TilesModel model = this.getTilesModel();
        if (model == null) {
            return null;
        }
        return model.findDefinition(viewName);
    }
}

