/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.toolWindow;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.web.mvc.jam.RequestMethod;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewSettings;
import com.intellij.spring.web.mvc.toolWindow.SpringMvcViewUtils;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Processor;
import com.intellij.xml.util.PsiElementPointer;
import icons.SpringMvcApiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMvcRequestMappingsPanel
extends FinderRecursivePanel<RequestMappingItem> {
    private final Set<Module> myModules;
    @Nullable
    private SpringBeanPointer myControllerSpringBeanPointer;

    public SpringMvcRequestMappingsPanel(@NotNull Project project, @Nullable String groupId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/web/mvc/toolWindow/SpringMvcRequestMappingsPanel", "<init>"));
        }
        super(project, groupId);
        this.myModules = new HashSet<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!SpringMvcRequestMappingsPanel.isRelevantModule(module)) continue;
            this.myModules.add(module);
        }
    }

    public SpringMvcRequestMappingsPanel(@NotNull FinderRecursivePanel parent, Module module) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/spring/web/mvc/toolWindow/SpringMvcRequestMappingsPanel", "<init>"));
        }
        super(parent);
        this.myModules = SpringMvcRequestMappingsPanel.getRelevantModules(module);
    }

    public SpringMvcRequestMappingsPanel(FinderRecursivePanel<SpringBeanPointer> parent, @NotNull SpringBeanPointer controllerSpringBeanPointer) {
        if (controllerSpringBeanPointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerSpringBeanPointer", "com/intellij/spring/web/mvc/toolWindow/SpringMvcRequestMappingsPanel", "<init>"));
        }
        super(parent);
        PsiFile myControllerFile = controllerSpringBeanPointer.getContainingFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)myControllerFile);
        this.myModules = SpringMvcRequestMappingsPanel.getRelevantModules(module);
        this.myControllerSpringBeanPointer = controllerSpringBeanPointer;
    }

    private static Set<Module> getRelevantModules(Module module) {
        HashSet<Module> modules = new HashSet<Module>();
        ModuleUtilCore.visitMeAndDependentModules((Module)module, module1 -> {
            if (SpringMvcRequestMappingsPanel.isRelevantModule(module1)) {
                modules.add(module1);
            }
            return true;
        });
        return modules;
    }

    private static boolean isRelevantModule(Module module) {
        return SpringCommonUtils.hasSpringFacet((Module)module) && !WebFacet.getInstances((Module)module).isEmpty();
    }

    @NotNull
    protected List<RequestMappingItem> getListItems() {
        ArrayList<RequestMappingItem> items = new ArrayList<RequestMappingItem>();
        Set<RequestMethod> requestMethods = SpringMvcViewSettings.getInstance(this.getProject()).getRequestMethods();
        Processor processor = variant -> {
            RequestMappingItem item = new RequestMappingItem(variant.getPresentation(), variant.getPsiElementPointer(), variant.isPattern(), variant.getMethod());
            items.add(item);
            return true;
        };
        for (Module module : this.myModules) {
            if (!SpringMvcViewUtils.processUrls(module, this.myControllerSpringBeanPointer, requestMethods, (Processor<SpringMVCModel.Variant>)processor)) break;
        }
        Collections.sort(items, (item, item2) -> item.getPresentation().compareToIgnoreCase(item2.getPresentation()));
        ArrayList<RequestMappingItem> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/toolWindow/SpringMvcRequestMappingsPanel", "getListItems"));
        }
        return arrayList;
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, RequestMappingItem value, int index, boolean selected, boolean hasFocus) {
        String requestMethodPresentation;
        String containingFileName;
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        comp.append(SpringMvcRequestMappingsPanel.getPathPresentation(value), value.isPattern() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myControllerSpringBeanPointer == null && (containingFileName = this.getContainingFileName(value)) != null) {
            comp.append(" (" + containingFileName + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if ((requestMethodPresentation = SpringMvcRequestMappingsPanel.getRequestMethodPresentation(value)) != null) {
            comp.append(" " + requestMethodPresentation, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
    }

    private static String getPathPresentation(RequestMappingItem item) {
        String presentation = item.getPresentation();
        return StringUtil.startsWithChar((CharSequence)presentation, (char)'/') ? presentation : "/" + presentation;
    }

    @Nullable
    private String getContainingFileName(RequestMappingItem item) {
        VirtualFile file = this.getContainingFile(item);
        return file == null ? null : file.getName();
    }

    @Nullable
    private static String getRequestMethodPresentation(RequestMappingItem item) {
        if (item.getMethod().length == 0) {
            return null;
        }
        return RequestMethod.getDisplay((RequestMethod[])item.getMethod());
    }

    @NotNull
    protected String getItemText(RequestMappingItem item) {
        String string = SpringMvcRequestMappingsPanel.getPathPresentation(item) + " " + StringUtil.notNullize((String)this.getContainingFileName(item)) + " " + StringUtil.notNullize((String)SpringMvcRequestMappingsPanel.getRequestMethodPresentation(item));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/toolWindow/SpringMvcRequestMappingsPanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(RequestMappingItem item) {
        return SpringMvcApiIcons.RequestMapping;
    }

    protected boolean hasChildren(RequestMappingItem item) {
        return false;
    }

    @Nullable
    protected VirtualFile getContainingFile(RequestMappingItem item) {
        PsiElementPointer pointer = item.getPointer();
        if (pointer instanceof SpringBeanPointer && !((SpringBeanPointer)pointer).isValid()) {
            return null;
        }
        PsiElement psiElement = pointer.getPsiElement();
        return psiElement == null ? null : psiElement.getContainingFile().getVirtualFile();
    }

    protected boolean performEditAction() {
        RequestMappingItem value = (RequestMappingItem)this.getSelectedValue();
        assert (value != null);
        PsiElement element = value.getPointer().getPsiElement();
        if (element != null) {
            NavigationUtil.activateFileWithPsiElement((PsiElement)element);
        }
        return true;
    }

    protected JComponent createDefaultRightComponent() {
        if (!this.isShowDoc()) {
            return null;
        }
        return super.createDefaultRightComponent();
    }

    @Nullable
    protected JComponent createRightComponent(RequestMappingItem item) {
        if (!this.isShowDoc()) {
            return null;
        }
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout(0, 2));
        PsiElement element = item.getPointer().getPsiElement();
        if (element == null || this.isDisposed()) {
            return panel;
        }
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
        DocumentationComponent documentationComponent = new DocumentationComponent(manager);
        Disposer.register((Disposable)this, (Disposable)documentationComponent);
        manager.fetchDocInfo(element, documentationComponent);
        panel.add((Component)documentationComponent, (Object)"North");
        return panel;
    }

    private boolean isShowDoc() {
        return SpringMvcViewSettings.getInstance(this.getProject()).isShowDoc();
    }

    public static class RequestMappingItem {
        private final String myPresentation;
        private final PsiElementPointer myPointer;
        private final boolean myPattern;
        private final RequestMethod[] myMethod;

        public RequestMappingItem(String presentation, PsiElementPointer pointer, boolean pattern, RequestMethod ... method) {
            this.myPresentation = presentation;
            this.myPointer = pointer;
            this.myPattern = pattern;
            this.myMethod = method;
        }

        public String getPresentation() {
            return this.myPresentation;
        }

        public PsiElementPointer getPointer() {
            return this.myPointer;
        }

        public boolean isPattern() {
            return this.myPattern;
        }

        public RequestMethod[] getMethod() {
            return this.myMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestMappingItem that = (RequestMappingItem)o;
            if (!this.myPresentation.equals(that.myPresentation)) {
                return false;
            }
            if (this.myPattern != that.myPattern) {
                return false;
            }
            if (!Arrays.equals(this.myMethod, that.myMethod)) {
                return false;
            }
            return !(this.myPointer != null ? !this.myPointer.equals(that.myPointer) : that.myPointer != null);
        }

        public int hashCode() {
            int result = this.myPresentation.hashCode();
            result = 31 * result + (this.myPointer != null ? this.myPointer.hashCode() : 0);
            result = 31 * result + (this.myPattern ? 1 : 0);
            result = 31 * result + (this.myMethod != null ? Arrays.hashCode(this.myMethod) : 0);
            return result;
        }
    }
}

